/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.udp;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.channel.socket.DatagramChannel;
import io.micrometer.shaded.io.netty.handler.logging.LoggingHandler;
import io.micrometer.shaded.io.netty.util.NetUtil;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoSink;
import io.micrometer.shaded.reactor.ipc.netty.NettyConnector;
import io.micrometer.shaded.reactor.ipc.netty.NettyContext;
import io.micrometer.shaded.reactor.ipc.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.ipc.netty.channel.ContextHandler;
import io.micrometer.shaded.reactor.ipc.netty.options.ClientOptions;
import io.micrometer.shaded.reactor.ipc.netty.options.NettyOptions;
import io.micrometer.shaded.reactor.ipc.netty.udp.UdpClientOptions;
import io.micrometer.shaded.reactor.ipc.netty.udp.UdpInbound;
import io.micrometer.shaded.reactor.ipc.netty.udp.UdpOperations;
import io.micrometer.shaded.reactor.ipc.netty.udp.UdpOutbound;
import io.micrometer.shaded.reactor.ipc.netty.udp.UdpResources;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public final class UdpClient
implements NettyConnector<UdpInbound, UdpOutbound> {
    final UdpClientOptions options;
    static final LoggingHandler loggingHandler = new LoggingHandler(UdpClient.class);

    public static UdpClient create() {
        return UdpClient.create(NetUtil.LOCALHOST.getHostAddress());
    }

    public static UdpClient create(String bindAddress) {
        return UdpClient.create(bindAddress, NettyOptions.DEFAULT_PORT);
    }

    public static UdpClient create(int port) {
        return UdpClient.create(NetUtil.LOCALHOST.getHostAddress(), port);
    }

    public static UdpClient create(String bindAddress, int port) {
        return UdpClient.create((? super ClientOptions.Builder<?> opts) -> ((ClientOptions.Builder)opts.host(bindAddress)).port(port));
    }

    public static UdpClient create(Consumer<? super ClientOptions.Builder<?>> options) {
        return UdpClient.builder().options(options).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private UdpClient(Builder builder) {
        UdpClientOptions.Builder clientOptionsBuilder = UdpClientOptions.builder();
        if (Objects.nonNull(builder.options)) {
            builder.options.accept(clientOptionsBuilder);
        }
        if (!clientOptionsBuilder.isLoopAvailable()) {
            clientOptionsBuilder.loopResources(UdpResources.get());
        }
        this.options = clientOptionsBuilder.build();
    }

    @Override
    public Mono<? extends NettyContext> newHandler(BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>> handler) {
        BiFunction<Object, Object, Publisher<Void>> targetHandler = null == handler ? ChannelOperations.noopHandler() : handler;
        return Mono.create((MonoSink<T> sink) -> {
            Bootstrap b = this.options.get();
            SocketAddress adr = this.options.getAddress();
            if (adr == null) {
                sink.error(new NullPointerException("Provided UdpClientOptions do not define any address to bind to "));
                return;
            }
            b.remoteAddress(adr);
            ContextHandler<DatagramChannel> c = this.doHandler((BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>>)targetHandler, (MonoSink<NettyContext>)sink, adr);
            b.handler(c);
            c.setFuture(b.connect());
        });
    }

    protected ContextHandler<DatagramChannel> doHandler(BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>> handler, MonoSink<NettyContext> sink, SocketAddress providedAddress) {
        return ContextHandler.newClientContext(sink, this.options, loggingHandler, false, providedAddress, (ch, c, msg) -> UdpOperations.bind(ch, handler, c));
    }

    public static final class Builder {
        private Consumer<? super UdpClientOptions.Builder> options;

        private Builder() {
        }

        public final Builder options(Consumer<? super UdpClientOptions.Builder> options) {
            this.options = Objects.requireNonNull(options, "options");
            return this;
        }

        public UdpClient build() {
            return new UdpClient(this);
        }
    }
}

