/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.http.websocket;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.ipc.netty.NettyOutbound;
import java.nio.charset.Charset;
import java.util.function.Function;

public interface WebsocketOutbound
extends NettyOutbound {
    public static final Function<? super String, ? extends WebSocketFrame> stringToWebsocketFrame = TextWebSocketFrame::new;
    public static final Function<? super ByteBuf, ? extends WebSocketFrame> bytebufToWebsocketFrame = BinaryWebSocketFrame::new;

    public String selectedSubprotocol();

    @Override
    default public NettyOutbound send(Publisher<? extends ByteBuf> dataStream) {
        return this.sendObject(Flux.from(dataStream).map(bytebufToWebsocketFrame));
    }

    @Override
    default public NettyOutbound sendString(Publisher<? extends String> dataStream, Charset charset) {
        return this.sendObject(Flux.from(dataStream).map(stringToWebsocketFrame));
    }
}

