/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty;

import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelInboundHandler;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.ipc.netty.ReactorNetty;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public interface NettyPipeline {
    public static final String LEFT = "io.micrometer.shaded.reactor.left.";
    public static final String RIGHT = "io.micrometer.shaded.reactor.right.";
    public static final String SslHandler = "io.micrometer.shaded.reactor.left.sslHandler";
    public static final String SslReader = "io.micrometer.shaded.reactor.left.sslReader";
    public static final String SslLoggingHandler = "io.micrometer.shaded.reactor.left.sslLoggingHandler";
    public static final String ProxyHandler = "io.micrometer.shaded.reactor.left.proxyHandler";
    public static final String ReactiveBridge = "io.micrometer.shaded.reactor.right.reactiveBridge";
    public static final String HttpCodec = "io.micrometer.shaded.reactor.left.httpCodec";
    public static final String HttpDecompressor = "io.micrometer.shaded.reactor.left.decompressor";
    public static final String HttpCompressor = "io.micrometer.shaded.reactor.left.compressor";
    public static final String HttpAggregator = "io.micrometer.shaded.reactor.left.httpAggregator";
    public static final String HttpServerHandler = "io.micrometer.shaded.reactor.left.httpServerHandler";
    public static final String OnChannelWriteIdle = "io.micrometer.shaded.reactor.left.onChannelWriteIdle";
    public static final String OnChannelReadIdle = "io.micrometer.shaded.reactor.left.onChannelReadIdle";
    public static final String ChunkedWriter = "io.micrometer.shaded.reactor.left.chunkedWriter";
    public static final String LoggingHandler = "io.micrometer.shaded.reactor.left.loggingHandler";
    public static final String CompressionHandler = "io.micrometer.shaded.reactor.left.compressionHandler";

    public static ChannelInboundHandler inboundHandler(BiConsumer<? super ChannelHandlerContext, Object> handler) {
        return new ReactorNetty.ExtractorHandler(handler);
    }

    public static Object handlerTerminatedEvent() {
        return ReactorNetty.TERMINATED;
    }

    public static Object responseCompressionEvent() {
        return ReactorNetty.RESPONSE_COMPRESSION_EVENT;
    }

    public static final class SendOptionsChangeEvent {
        final Consumer<? super SendOptions> configurator;
        final Publisher<?> source;

        SendOptionsChangeEvent(Consumer<? super SendOptions> configurator, Publisher<?> source) {
            this.configurator = Objects.requireNonNull(configurator, "configurator");
            this.source = source;
        }

        public Consumer<? super SendOptions> configurator() {
            return this.configurator;
        }
    }

    public static interface SendOptions {
        public SendOptions flushOnBoundary();

        default public SendOptions flushOnEach() {
            return this.flushOnEach(true);
        }

        public SendOptions flushOnEach(boolean var1);
    }
}

