/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.buffer.ByteBufAllocator;
import io.micrometer.shaded.io.netty.buffer.ByteBufHolder;
import io.micrometer.shaded.io.netty.util.ReferenceCounted;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.FluxOperator;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.ipc.netty.ByteBufMono;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Function;

public final class ByteBufFlux
extends FluxOperator<ByteBuf, ByteBuf> {
    final ByteBufAllocator alloc;
    static final Function<Object, ByteBuf> bytebufExtractor = o -> {
        if (o instanceof ByteBuf) {
            return (ByteBuf)o;
        }
        if (o instanceof ByteBufHolder) {
            return ((ByteBufHolder)o).content();
        }
        throw new IllegalArgumentException("Object " + o + " of type " + o.getClass() + " cannot be converted to ByteBuf");
    };
    static final int MAX_CHUNK_SIZE = 524288;

    public static ByteBufFlux fromInbound(Publisher<?> source) {
        return ByteBufFlux.fromInbound(source, ByteBufAllocator.DEFAULT);
    }

    public static ByteBufFlux fromInbound(Publisher<?> source, ByteBufAllocator allocator) {
        Objects.requireNonNull(allocator, "allocator");
        return new ByteBufFlux(Flux.from(source).map(bytebufExtractor), allocator);
    }

    public static ByteBufFlux fromPath(Path path) {
        return ByteBufFlux.fromPath(path, 524288);
    }

    public static ByteBufFlux fromPath(Path path, int maxChunkSize) {
        return ByteBufFlux.fromPath(path, maxChunkSize, ByteBufAllocator.DEFAULT);
    }

    public static ByteBufFlux fromPath(Path path, ByteBufAllocator allocator) {
        return ByteBufFlux.fromPath(path, 524288, allocator);
    }

    public static ByteBufFlux fromPath(Path path, int maxChunkSize, ByteBufAllocator allocator) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(allocator, "allocator");
        if (maxChunkSize < 1) {
            throw new IllegalArgumentException("chunk size must be strictly positive, was: " + maxChunkSize);
        }
        return new ByteBufFlux(Flux.generate(() -> FileChannel.open(path, new OpenOption[0]), (fc, sink) -> {
            ByteBuf buf = allocator.buffer();
            try {
                if (buf.writeBytes((ScatteringByteChannel)fc, maxChunkSize) < 0) {
                    buf.release();
                    sink.complete();
                } else {
                    sink.next(buf);
                }
            }
            catch (IOException e) {
                buf.release();
                sink.error(e);
            }
            return fc;
        }), allocator);
    }

    public final Flux<ByteBuffer> asByteBuffer() {
        return this.map(ByteBuf::nioBuffer);
    }

    public final Flux<byte[]> asByteArray() {
        return this.map(bb -> {
            byte[] bytes = new byte[bb.readableBytes()];
            bb.readBytes(bytes);
            return bytes;
        });
    }

    public Flux<InputStream> asInputStream() {
        return this.map(ByteBufMono.ReleasingInputStream::new);
    }

    public final Flux<String> asString() {
        return this.asString(Charset.defaultCharset());
    }

    public final Flux<String> asString(Charset charset) {
        return this.map(bb -> bb.toString(charset));
    }

    public ByteBufMono aggregate() {
        return Mono.using(this.alloc::compositeBuffer, (? super D b) -> this.reduce(b, (prev, next) -> prev.addComponent(next.retain())).doOnNext(cbb -> cbb.writerIndex(cbb.capacity())).filter(ByteBuf::isReadable), ReferenceCounted::release).as(ByteBufMono::new);
    }

    public ByteBufMono multicast() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ByteBufFlux retain() {
        return new ByteBufFlux(this.doOnNext(ByteBuf::retain), this.alloc);
    }

    ByteBufFlux(Flux<ByteBuf> source, ByteBufAllocator allocator) {
        super(source);
        this.alloc = allocator;
    }

    @Override
    public void subscribe(CoreSubscriber<? super ByteBuf> s) {
        this.source.subscribe(s);
    }
}

