/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class CumulativeTimer
extends AbstractTimer {
    private final AtomicLong count = new AtomicLong();
    private final AtomicLong total = new AtomicLong();
    private final AtomicLong max = new AtomicLong();

    public CumulativeTimer(Meter.Id id, Clock clock, HistogramConfig histogramConfig) {
        super(id, clock, histogramConfig);
    }

    @Override
    protected void recordNonNegative(long amount, TimeUnit unit) {
        long nanoAmount = (long)TimeUtils.convert(amount, unit, TimeUnit.NANOSECONDS);
        this.count.getAndAdd(1L);
        this.total.getAndAdd(nanoAmount);
        this.updateMax(nanoAmount);
    }

    @Override
    public long count() {
        return this.count.get();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.total.get(), unit);
    }

    @Override
    public double max(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.max.get(), unit);
    }

    @Override
    public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.Count), new Measurement(() -> this.totalTime(TimeUnit.NANOSECONDS), Statistic.TotalTime), new Measurement(() -> this.totalTime(TimeUnit.NANOSECONDS), Statistic.Max));
    }

    private void updateMax(long nanoAmount) {
        long currentMax;
        do {
            if ((currentMax = this.max.get()) < nanoAmount) continue;
            return;
        } while (!this.max.compareAndSet(currentMax, nanoAmount));
    }
}

