/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.HistogramSnapshot;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface DistributionSummary
extends Meter {
    public void record(double var1);

    public long count();

    public double totalAmount();

    default public double mean() {
        return this.count() == 0L ? 0.0 : this.totalAmount() / (double)this.count();
    }

    public double max();

    public double percentile(double var1);

    public double histogramCountAtValue(long var1);

    public HistogramSnapshot takeSnapshot(boolean var1);

    public static Builder builder(String name) {
        return new Builder(name);
    }

    @Override
    default public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.Count), new Measurement(this::totalAmount, Statistic.Total));
    }

    public static class Builder {
        private final String name;
        private final List<Tag> tags = new ArrayList<Tag>();
        private String description;
        private String baseUnit;
        private HistogramConfig.Builder histogramConfigBuilder = HistogramConfig.builder();

        private Builder(String name) {
            this.name = name;
        }

        public Builder tags(String ... tags) {
            return this.tags(Tags.zip(tags));
        }

        public Builder tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder baseUnit(String unit) {
            this.baseUnit = unit;
            return this;
        }

        public Builder publishPercentiles(double ... percentiles) {
            this.histogramConfigBuilder.percentiles(percentiles);
            return this;
        }

        public Builder publishPercentileHistogram() {
            return this.publishPercentileHistogram(true);
        }

        public Builder publishPercentileHistogram(Boolean enabled) {
            this.histogramConfigBuilder.percentilesHistogram(enabled);
            return this;
        }

        public Builder sla(long ... sla) {
            this.histogramConfigBuilder.sla(sla);
            return this;
        }

        public Builder minimumExpectedValue(Long min) {
            this.histogramConfigBuilder.minimumExpectedValue(min);
            return this;
        }

        public Builder maximumExpectedValue(Long max) {
            this.histogramConfigBuilder.maximumExpectedValue(max);
            return this;
        }

        public Builder histogramExpiry(Duration expiry) {
            this.histogramConfigBuilder.histogramExpiry(expiry);
            return this;
        }

        public Builder histogramBufferLength(Integer bufferLength) {
            this.histogramConfigBuilder.histogramBufferLength(bufferLength);
            return this;
        }

        public DistributionSummary register(MeterRegistry registry) {
            return registry.summary(new Meter.Id(this.name, this.tags, this.baseUnit, this.description, Meter.Type.DistributionSummary), this.histogramConfigBuilder.build());
        }
    }
}

