/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.step;

import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.step.StepDouble;
import io.micrometer.core.instrument.step.StepLong;
import java.util.Arrays;

public class StepDistributionSummary
extends AbstractDistributionSummary {
    private final StepLong count;
    private final StepDouble total;
    private final StepDouble max;

    public StepDistributionSummary(Meter.Id id, Clock clock, HistogramConfig histogramConfig, long stepMillis) {
        super(id, clock, histogramConfig);
        this.count = new StepLong(clock, stepMillis);
        this.total = new StepDouble(clock, stepMillis);
        this.max = new StepDouble(clock, stepMillis);
    }

    @Override
    protected void recordNonNegative(double amount) {
        this.count.getCurrent().add(1L);
        this.total.getCurrent().add(amount);
        this.max.getCurrent().add(Math.max(amount - this.max.getCurrent().doubleValue(), 0.0));
    }

    @Override
    public long count() {
        return (long)this.count.poll();
    }

    @Override
    public double totalAmount() {
        return this.total.poll();
    }

    @Override
    public double max() {
        return this.max.poll();
    }

    @Override
    public Iterable<Measurement> measure() {
        Measurement[] measurementArray = new Measurement[3];
        measurementArray[0] = new Measurement(() -> this.count(), Statistic.Count);
        measurementArray[1] = new Measurement(this::totalAmount, Statistic.Total);
        measurementArray[2] = new Measurement(this.max::poll, Statistic.Max);
        return Arrays.asList(measurementArray);
    }
}

