/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.simple.SimpleConfig;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.util.TimeUtils;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;

public class SimpleMeterRegistry
extends StepMeterRegistry {
    private final DecimalFormat percentileFormat = new DecimalFormat("#.####");

    public SimpleMeterRegistry() {
        this(SimpleConfig.DEFAULT, Clock.SYSTEM);
    }

    public SimpleMeterRegistry(SimpleConfig config, Clock clock) {
        super(config, clock);
    }

    @Override
    protected void publish() {
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, HistogramConfig histogramConfig) {
        DistributionSummary summary = super.newDistributionSummary(id, histogramConfig);
        for (double percentile : histogramConfig.getPercentiles()) {
            this.gauge(id.getName(), Tags.concat(this.getConventionTags(id), "percentile", this.percentileFormat.format(percentile)), percentile, summary::percentile);
        }
        if (histogramConfig.isPublishingHistogram()) {
            Object object = histogramConfig.getHistogramBuckets(false).iterator();
            while (object.hasNext()) {
                Long bucket = (Long)object.next();
                this.more().counter(this.getConventionName(id), Tags.concat(this.getConventionTags(id), "bucket", Long.toString(bucket)), summary, (T s) -> s.histogramCountAtValue(bucket));
            }
        }
        return summary;
    }

    @Override
    protected Timer newTimer(Meter.Id id, HistogramConfig histogramConfig) {
        Timer timer = super.newTimer(id, histogramConfig);
        for (double percentile : histogramConfig.getPercentiles()) {
            this.gauge(id.getName(), Tags.concat(this.getConventionTags(id), "percentile", this.percentileFormat.format(percentile)), percentile, p -> timer.percentile((double)p, this.getBaseTimeUnit()));
        }
        if (histogramConfig.isPublishingHistogram()) {
            Object object = histogramConfig.getHistogramBuckets(false).iterator();
            while (object.hasNext()) {
                Long bucket = (Long)object.next();
                this.more().counter(this.getConventionName(id), Tags.concat(this.getConventionTags(id), "bucket", this.percentileFormat.format(TimeUtils.nanosToUnit(bucket.longValue(), this.getBaseTimeUnit()))), timer, (T t) -> t.histogramCountAtValue(bucket));
            }
        }
        return timer;
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }
}

