/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.histogram;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.LatencyUtils.LatencyStats;

@Incubating(since="1.0.0-rc.3")
public class TimeWindowLatencyHistogram {
    private final Clock clock;
    private final HistogramConfig config;
    private final LatencyStats[] ringBuffer;
    private int currentBucket;
    private long lastRotateTimestampMillis;
    private final long durationBetweenRotatesMillis;
    private final AtomicBoolean accumulatedHistogramStale = new AtomicBoolean(false);
    private final Histogram accumulatedHistogram;

    public TimeWindowLatencyHistogram(Clock clock, HistogramConfig histogramConfig) {
        this.clock = clock;
        this.config = histogramConfig;
        int ageBuckets = histogramConfig.getHistogramBufferLength();
        this.ringBuffer = new LatencyStats[ageBuckets];
        for (int i = 0; i < ageBuckets; ++i) {
            this.ringBuffer[i] = this.buildLatencyStats();
        }
        this.currentBucket = 0;
        this.lastRotateTimestampMillis = clock.wallTime();
        this.durationBetweenRotatesMillis = histogramConfig.getHistogramExpiry().toMillis() / (long)ageBuckets;
        this.accumulatedHistogram = new Histogram((AbstractHistogram)this.ringBuffer[0].getIntervalHistogram());
    }

    public double percentile(double percentile, TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.current().getValueAtPercentile(percentile * 100.0), unit);
    }

    public double histogramCountAtValue(long valueNanos) {
        return this.current().getCountBetweenValues(0L, valueNanos);
    }

    public void record(long valueNano) {
        this.rotate();
        try {
            for (LatencyStats histogram : this.ringBuffer) {
                histogram.recordLatency(valueNano);
            }
            this.accumulatedHistogramStale.compareAndSet(false, true);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void rotate() {
        long timeSinceLastRotateMillis = this.clock.wallTime() - this.lastRotateTimestampMillis;
        while (timeSinceLastRotateMillis > this.durationBetweenRotatesMillis) {
            this.ringBuffer[this.currentBucket] = this.buildLatencyStats();
            this.accumulatedHistogram.reset();
            if (++this.currentBucket >= this.ringBuffer.length) {
                this.currentBucket = 0;
            }
            timeSinceLastRotateMillis -= this.durationBetweenRotatesMillis;
            this.lastRotateTimestampMillis += this.durationBetweenRotatesMillis;
            this.accumulatedHistogramStale.compareAndSet(false, true);
        }
    }

    private Histogram current() {
        this.rotate();
        if (this.accumulatedHistogramStale.compareAndSet(true, false)) {
            this.ringBuffer[this.currentBucket].addIntervalHistogramTo(this.accumulatedHistogram);
        }
        return this.accumulatedHistogram;
    }

    private LatencyStats buildLatencyStats() {
        return new LatencyStats.Builder().lowestTrackableLatency(this.config.getMinimumExpectedValue().longValue()).highestTrackableLatency(this.config.getMaximumExpectedValue().longValue()).build();
    }
}

