/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.dropwizard;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.NamingConvention;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.dropwizard.DropwizardCounter;
import io.micrometer.core.instrument.dropwizard.DropwizardDistributionSummary;
import io.micrometer.core.instrument.dropwizard.DropwizardGauge;
import io.micrometer.core.instrument.dropwizard.DropwizardTimer;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;

public class DropwizardMeterRegistry
extends MeterRegistry {
    private final MetricRegistry registry;
    private final HierarchicalNameMapper nameMapper;
    private final DecimalFormat percentileFormat = new DecimalFormat("#.####");

    public DropwizardMeterRegistry(HierarchicalNameMapper nameMapper, Clock clock) {
        super(clock);
        this.registry = new MetricRegistry();
        this.nameMapper = nameMapper;
        this.config().namingConvention(NamingConvention.camelCase);
    }

    public MetricRegistry getDropwizardRegistry() {
        return this.registry;
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        return new DropwizardCounter(id, this.registry.meter(this.hierarchicalName(id)));
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        WeakReference ref = new WeakReference(obj);
        com.codahale.metrics.Gauge gauge = () -> {
            Object obj2 = ref.get();
            return obj2 != null ? f.applyAsDouble(ref.get()) : Double.NaN;
        };
        this.registry.register(this.hierarchicalName(id), (Metric)gauge);
        return new DropwizardGauge(id, (com.codahale.metrics.Gauge<Double>)gauge);
    }

    @Override
    protected Timer newTimer(Meter.Id id, HistogramConfig histogramConfig) {
        DropwizardTimer timer = new DropwizardTimer(id, this.registry.timer(this.hierarchicalName(id)), this.clock, histogramConfig);
        for (double percentile : histogramConfig.getPercentiles()) {
            this.gauge(id.getName(), Tags.concat(this.getConventionTags(id), "percentile", this.percentileFormat.format(percentile)), percentile, p -> timer.percentile((double)p, this.getBaseTimeUnit()));
        }
        if (histogramConfig.isPublishingHistogram()) {
            Object object = histogramConfig.getHistogramBuckets(false).iterator();
            while (object.hasNext()) {
                Long bucket = (Long)object.next();
                this.more().counter(this.getConventionName(id), Tags.concat(this.getConventionTags(id), "bucket", Long.toString(bucket)), timer, (T t) -> t.histogramCountAtValue(bucket));
            }
        }
        return timer;
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, HistogramConfig histogramConfig) {
        DropwizardDistributionSummary summary = new DropwizardDistributionSummary(id, this.clock, this.registry.histogram(this.hierarchicalName(id)), histogramConfig);
        for (double percentile : histogramConfig.getPercentiles()) {
            this.gauge(id.getName(), Tags.concat(this.getConventionTags(id), "percentile", this.percentileFormat.format(percentile)), percentile, summary::percentile);
        }
        if (histogramConfig.isPublishingHistogram()) {
            Object object = histogramConfig.getHistogramBuckets(false).iterator();
            while (object.hasNext()) {
                Long bucket = (Long)object.next();
                this.more().counter(this.getConventionName(id), Tags.concat(this.getConventionTags(id), "bucket", Long.toString(bucket)), summary, (T s) -> s.histogramCountAtValue(bucket));
            }
        }
        return summary;
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        DefaultLongTaskTimer ltt = new DefaultLongTaskTimer(id, this.clock);
        this.registry.register(this.hierarchicalName(id.withTag(Statistic.ActiveTasks)), (Metric)((com.codahale.metrics.Gauge)ltt::activeTasks));
        this.registry.register(this.hierarchicalName(id.withTag(Statistic.Duration)), (Metric)((com.codahale.metrics.Gauge)() -> ltt.duration(TimeUnit.NANOSECONDS)));
        return ltt;
    }

    @Override
    protected void newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        measurements.forEach(ms -> {
            com.codahale.metrics.Gauge cfr_ignored_0 = (com.codahale.metrics.Gauge)this.registry.register(this.hierarchicalName(id.withTag(ms.getStatistic())), (Metric)((com.codahale.metrics.Gauge)ms::getValue));
        });
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.NANOSECONDS;
    }

    private String hierarchicalName(Meter.Id id) {
        return this.nameMapper.toHierarchicalName(id, this.config().namingConvention());
    }
}

