/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.dropwizard;

import com.codahale.metrics.Histogram;
import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.step.StepDouble;
import io.micrometer.core.instrument.util.MeterEquivalence;
import java.util.concurrent.atomic.DoubleAdder;

public class DropwizardDistributionSummary
extends AbstractDistributionSummary {
    private final Histogram impl;
    private final DoubleAdder totalAmount = new DoubleAdder();
    private final StepDouble max;

    DropwizardDistributionSummary(Meter.Id id, Clock clock, Histogram impl, HistogramConfig histogramConfig) {
        super(id, clock, histogramConfig);
        this.impl = impl;
        this.max = new StepDouble(clock, 60000L);
    }

    @Override
    protected void recordNonNegative(double amount) {
        if (amount >= 0.0) {
            this.impl.update((long)amount);
            this.totalAmount.add(amount);
            this.max.getCurrent().add(Math.max(amount - this.max.getCurrent().doubleValue(), 0.0));
        }
    }

    @Override
    public long count() {
        return this.impl.getCount();
    }

    @Override
    public double totalAmount() {
        return this.totalAmount.doubleValue();
    }

    @Override
    public double max() {
        return this.max.poll();
    }

    public boolean equals(Object o) {
        return MeterEquivalence.equals(this, o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode(this);
    }
}

