/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeter;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.noop.NoopTimer;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class CompositeTimer
extends AbstractMeter
implements Timer,
CompositeMeter {
    private final Map<MeterRegistry, Timer> timers = new ConcurrentHashMap<MeterRegistry, Timer>();
    private final HistogramConfig histogramConfig;

    CompositeTimer(Meter.Id id, HistogramConfig histogramConfig) {
        super(id);
        this.histogramConfig = histogramConfig;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        this.timers.values().forEach(ds -> ds.record(amount, unit));
    }

    @Override
    public void record(Duration duration) {
        this.firstTimer().record(duration);
    }

    @Override
    public <T> T record(Supplier<T> f) {
        return this.firstTimer().record(f);
    }

    @Override
    public <T> T recordCallable(Callable<T> f) throws Exception {
        return this.firstTimer().recordCallable(f);
    }

    @Override
    public void record(Runnable f) {
        this.firstTimer().record(f);
    }

    @Override
    public Runnable wrap(Runnable f) {
        return this.firstTimer().wrap(f);
    }

    @Override
    public <T> Callable<T> wrap(Callable<T> f) {
        return this.firstTimer().wrap(f);
    }

    @Override
    public long count() {
        return this.firstTimer().count();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return this.firstTimer().totalTime(unit);
    }

    @Override
    public double max(TimeUnit unit) {
        return this.firstTimer().max(unit);
    }

    @Override
    public double percentile(double percentile, TimeUnit unit) {
        return this.firstTimer().percentile(percentile, unit);
    }

    @Override
    public double histogramCountAtValue(long valueNanos) {
        return this.firstTimer().histogramCountAtValue(valueNanos);
    }

    private Timer firstTimer() {
        return this.timers.values().stream().findFirst().orElse(new NoopTimer(this.getId()));
    }

    @Override
    public void add(MeterRegistry registry) {
        long[] slaNanos = this.histogramConfig.getSlaBoundaries();
        Duration[] sla = new Duration[slaNanos.length];
        for (int i = 0; i < slaNanos.length; ++i) {
            sla[i] = Duration.ofNanos(slaNanos[i]);
        }
        Timer.Builder builder = Timer.builder(this.getId().getName()).tags(this.getId().getTags()).description(this.getId().getDescription()).maximumExpectedValue(Duration.ofNanos(this.histogramConfig.getMaximumExpectedValue())).minimumExpectedValue(Duration.ofNanos(this.histogramConfig.getMinimumExpectedValue())).publishPercentiles(this.histogramConfig.getPercentiles()).publishPercentileHistogram(this.histogramConfig.isPercentileHistogram()).maximumExpectedValue(Duration.ofNanos(this.histogramConfig.getMaximumExpectedValue())).minimumExpectedValue(Duration.ofNanos(this.histogramConfig.getMinimumExpectedValue())).histogramBufferLength(this.histogramConfig.getHistogramBufferLength()).histogramExpiry(this.histogramConfig.getHistogramExpiry()).sla(sla);
        this.timers.put(registry, builder.register(registry));
    }

    @Override
    public void remove(MeterRegistry registry) {
        this.timers.remove(registry);
    }
}

