/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeter;
import io.micrometer.core.instrument.noop.NoopLongTaskTimer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class CompositeLongTaskTimer
extends AbstractMeter
implements LongTaskTimer,
CompositeMeter {
    private final Map<MeterRegistry, LongTaskTimer> timers = new ConcurrentHashMap<MeterRegistry, LongTaskTimer>();

    CompositeLongTaskTimer(Meter.Id id) {
        super(id);
    }

    @Override
    public long start() {
        return this.timers.values().stream().map(LongTaskTimer::start).reduce((t1, t2) -> t2).orElse(-1L);
    }

    @Override
    public long stop(long task) {
        return this.timers.values().stream().map(ltt -> ltt.stop(task)).reduce((t1, t2) -> t2 == -1L ? t1 : t2).orElse(-1L);
    }

    @Override
    public double duration(long task, TimeUnit unit) {
        return this.timers.values().stream().map(ltt -> ltt.duration(task, unit)).reduce((t1, t2) -> t2 == -1.0 ? t1 : t2).orElse(-1.0);
    }

    @Override
    public double duration(TimeUnit unit) {
        return this.firstLongTaskTimer().duration(unit);
    }

    @Override
    public int activeTasks() {
        return this.firstLongTaskTimer().activeTasks();
    }

    private LongTaskTimer firstLongTaskTimer() {
        return this.timers.values().stream().findFirst().orElse(new NoopLongTaskTimer(this.getId()));
    }

    @Override
    public void add(MeterRegistry registry) {
        this.timers.put(registry, LongTaskTimer.builder(this.getId().getName()).tags(this.getId().getTags()).description(this.getId().getDescription()).register(registry));
    }

    @Override
    public void remove(MeterRegistry registry) {
        this.timers.remove(registry);
    }
}

