/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeter;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.noop.NoopDistributionSummary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CompositeDistributionSummary
extends AbstractMeter
implements DistributionSummary,
CompositeMeter {
    private final Map<MeterRegistry, DistributionSummary> distributionSummaries = new ConcurrentHashMap<MeterRegistry, DistributionSummary>();
    private final HistogramConfig histogramConfig;

    CompositeDistributionSummary(Meter.Id id, HistogramConfig histogramConfig) {
        super(id);
        this.histogramConfig = histogramConfig;
    }

    @Override
    public void record(double amount) {
        this.distributionSummaries.values().forEach(ds -> ds.record(amount));
    }

    @Override
    public long count() {
        return this.firstSummary().count();
    }

    @Override
    public double totalAmount() {
        return this.firstSummary().totalAmount();
    }

    @Override
    public double max() {
        return this.firstSummary().max();
    }

    @Override
    public double histogramCountAtValue(long value) {
        return this.firstSummary().histogramCountAtValue(value);
    }

    private DistributionSummary firstSummary() {
        return this.distributionSummaries.values().stream().findFirst().orElse(new NoopDistributionSummary(this.getId()));
    }

    @Override
    public double percentile(double percentile) {
        return this.firstSummary().percentile(percentile);
    }

    @Override
    public void add(MeterRegistry registry) {
        DistributionSummary.Builder builder = DistributionSummary.builder(this.getId().getName()).tags(this.getId().getTags()).description(this.getId().getDescription()).baseUnit(this.getId().getBaseUnit()).publishPercentiles(this.histogramConfig.getPercentiles()).publishPercentileHistogram(this.histogramConfig.isPercentileHistogram()).maximumExpectedValue(this.histogramConfig.getMaximumExpectedValue()).minimumExpectedValue(this.histogramConfig.getMinimumExpectedValue()).histogramBufferLength(this.histogramConfig.getHistogramBufferLength()).histogramExpiry(this.histogramConfig.getHistogramExpiry()).sla(this.histogramConfig.getSlaBoundaries());
        this.distributionSummaries.put(registry, builder.register(registry));
    }

    @Override
    public void remove(MeterRegistry registry) {
        this.distributionSummaries.remove(registry);
    }
}

