/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeter;
import io.micrometer.core.instrument.noop.NoopCounter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class CompositeCounter
extends AbstractMeter
implements Counter,
CompositeMeter {
    private final Map<MeterRegistry, Counter> counters = new ConcurrentHashMap<MeterRegistry, Counter>();

    CompositeCounter(Meter.Id id) {
        super(id);
    }

    @Override
    public void increment(double amount) {
        this.counters.values().forEach(c -> c.increment(amount));
    }

    @Override
    public double count() {
        return this.counters.values().stream().findFirst().orElse(new NoopCounter(this.getId())).count();
    }

    @Override
    public void add(MeterRegistry registry) {
        this.counters.put(registry, Counter.builder(this.getId().getName()).tags(this.getId().getTags()).description(this.getId().getDescription()).baseUnit(this.getId().getBaseUnit()).register(registry));
    }

    @Override
    public void remove(MeterRegistry registry) {
        this.counters.remove(registry);
    }
}

