/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.cache;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.statistics.StatisticsGateway;

public class EhCache2Metrics
implements MeterBinder {
    private final String name;
    private final Iterable<Tag> tags;
    private final StatisticsGateway stats;

    public static Ehcache monitor(MeterRegistry registry, Ehcache cache, String name, String ... tags) {
        return EhCache2Metrics.monitor(registry, cache, name, Tags.zip(tags));
    }

    public static Ehcache monitor(MeterRegistry registry, Ehcache cache, String name, Iterable<Tag> tags) {
        new EhCache2Metrics(cache, name, tags).bindTo(registry);
        return cache;
    }

    public EhCache2Metrics(Ehcache cache, String name, Iterable<Tag> tags) {
        this.stats = cache.getStatistics();
        this.name = name;
        this.tags = Tags.concat(tags, "name", cache.getName());
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Gauge.builder(this.name + ".size", this.stats, StatisticsGateway::getSize).tags(this.tags).tags("where", "local").description("The number of entries held locally in this cache").register(registry);
        Gauge.builder(this.name + ".size", this.stats, StatisticsGateway::getRemoteSize).tags(this.tags).tags("where", "remote").description("The number of entries held remotely in this cache").register(registry);
        FunctionCounter.builder(this.name + ".evictions", this.stats, StatisticsGateway::cacheEvictedCount).tags(this.tags).description("Cache evictions").register(registry);
        FunctionCounter.builder(this.name + ".removals", this.stats, StatisticsGateway::cacheRemoveCount).tags(this.tags).description("Cache removals").register(registry);
        FunctionCounter.builder(this.name + ".puts", this.stats, StatisticsGateway::cachePutAddedCount).tags(this.tags).tags("result", "added").description("Cache puts resulting in a new key/value pair").register(registry);
        FunctionCounter.builder(this.name + ".puts", this.stats, StatisticsGateway::cachePutAddedCount).tags(this.tags).tags("result", "updated").description("Cache puts resulting in an updated value").register(registry);
        this.requestMetrics(registry);
        this.commitTransactionMetrics(registry);
        this.rollbackTransactionMetrics(registry);
        this.recoveryTransactionMetrics(registry);
        Gauge.builder(this.name + ".local.offheap.size", this.stats, StatisticsGateway::getLocalOffHeapSize).tags(this.tags).description("Local off-heap size").baseUnit("bytes").register(registry);
        Gauge.builder(this.name + ".local.heap.size", this.stats, StatisticsGateway::getLocalHeapSizeInBytes).tags(this.tags).description("Local heap size").baseUnit("bytes").register(registry);
        Gauge.builder(this.name + ".local.disk.size", this.stats, StatisticsGateway::getLocalDiskSizeInBytes).tags(this.tags).description("Local disk size").baseUnit("bytes").register(registry);
    }

    private void requestMetrics(MeterRegistry registry) {
        FunctionCounter.builder(this.name + ".requests", this.stats, StatisticsGateway::cacheMissExpiredCount).tags(this.tags).tags("result", "miss", "reason", "expired").description("The number of times cache lookup methods have not returned a value, due to expiry").register(registry);
        FunctionCounter.builder(this.name + ".requests", this.stats, StatisticsGateway::cacheMissNotFoundCount).tags(this.tags).tags("result", "miss", "reason", "notFound").description("The number of times cache lookup methods have not returned a value, because the key was not found").register(registry);
        FunctionCounter.builder(this.name + ".requests", this.stats, StatisticsGateway::cacheHitCount).tags(this.tags).tags("result", "hit").description("The number of times cache lookup methods have returned a cached value.").register(registry);
    }

    private void commitTransactionMetrics(MeterRegistry registry) {
        FunctionCounter.builder(this.name + ".xa.commits", this.stats, StatisticsGateway::xaCommitReadOnlyCount).tags(this.tags).tags("result", "readOnly").description("Transaction commits that had a read-only result").register(registry);
        FunctionCounter.builder(this.name + ".xa.commits", this.stats, StatisticsGateway::xaCommitExceptionCount).tags(this.tags).tags("result", "exception").description("Transaction commits that failed").register(registry);
        FunctionCounter.builder(this.name + ".xa.commits", this.stats, StatisticsGateway::xaCommitCommittedCount).tags(this.tags).tags("result", "committed").description("Transaction commits that failed").register(registry);
    }

    private void rollbackTransactionMetrics(MeterRegistry registry) {
        FunctionCounter.builder(this.name + ".xa.rollbacks", this.stats, StatisticsGateway::xaRollbackExceptionCount).tags(this.tags).tags("result", "exception").description("Transaction rollbacks that failed").register(registry);
        FunctionCounter.builder(this.name + ".xa.rollbacks", this.stats, StatisticsGateway::xaRollbackSuccessCount).tags(this.tags).tags("result", "success").description("Transaction rollbacks that failed").register(registry);
    }

    private void recoveryTransactionMetrics(MeterRegistry registry) {
        FunctionCounter.builder(this.name + ".xa.recoveries", this.stats, StatisticsGateway::xaRecoveryNothingCount).tags(this.tags).tags("result", "nothing").description("Recovery transactions that recovered nothing").register(registry);
        FunctionCounter.builder(this.name + ".xa.recoveries", this.stats, StatisticsGateway::xaRecoveryRecoveredCount).tags(this.tags).tags("result", "success").description("Successful recovery transaction").register(registry);
    }
}

