/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterFilter;
import io.micrometer.core.instrument.NamingConvention;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.internal.DefaultFunctionTimer;
import io.micrometer.core.instrument.noop.NoopCounter;
import io.micrometer.core.instrument.noop.NoopDistributionSummary;
import io.micrometer.core.instrument.noop.NoopFunctionCounter;
import io.micrometer.core.instrument.noop.NoopFunctionTimer;
import io.micrometer.core.instrument.noop.NoopGauge;
import io.micrometer.core.instrument.noop.NoopLongTaskTimer;
import io.micrometer.core.instrument.noop.NoopMeter;
import io.micrometer.core.instrument.noop.NoopTimeGauge;
import io.micrometer.core.instrument.noop.NoopTimer;
import io.micrometer.core.instrument.util.TimeUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;

public abstract class MeterRegistry {
    protected final Clock clock;
    private final Map<Meter.Id, Meter> meterMap = new HashMap<Meter.Id, Meter>();
    private final List<MeterFilter> filters = new ArrayList<MeterFilter>();
    private NamingConvention namingConvention = NamingConvention.snakeCase;
    private final Config config = new Config();
    private final More more = new More();

    public MeterRegistry(Clock clock) {
        this.clock = clock;
    }

    protected abstract <T> Gauge newGauge(Meter.Id var1, T var2, ToDoubleFunction<T> var3);

    protected abstract Counter newCounter(Meter.Id var1);

    protected abstract LongTaskTimer newLongTaskTimer(Meter.Id var1);

    protected abstract Timer newTimer(Meter.Id var1, HistogramConfig var2);

    protected abstract DistributionSummary newDistributionSummary(Meter.Id var1, HistogramConfig var2);

    protected abstract void newMeter(Meter.Id var1, Meter.Type var2, Iterable<Measurement> var3);

    protected <T> TimeGauge newTimeGauge(final Meter.Id id, T obj, TimeUnit fUnit, ToDoubleFunction<T> f) {
        final TimeUnit baseTimeUnit = this.getBaseTimeUnit();
        id.setBaseUnit(this.getBaseTimeUnitStr());
        final Gauge gauge = this.newGauge(id, obj, obj2 -> TimeUtils.convert(f.applyAsDouble(obj2), fUnit, this.getBaseTimeUnit()));
        return new TimeGauge(){

            @Override
            public Meter.Id getId() {
                return id;
            }

            @Override
            public double value() {
                return gauge.value();
            }

            @Override
            public TimeUnit getBaseTimeUnit() {
                return baseTimeUnit;
            }
        };
    }

    protected <T> Meter newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
        DefaultFunctionTimer<T> ft = new DefaultFunctionTimer<T>(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnits, this.getBaseTimeUnit());
        this.newMeter(id, Meter.Type.Timer, ft.measure());
        return ft;
    }

    protected List<Tag> getConventionTags(Meter.Id id) {
        return id.getConventionTags(this.config().namingConvention());
    }

    protected String getConventionName(Meter.Id id) {
        return id.getConventionName(this.config().namingConvention());
    }

    protected abstract TimeUnit getBaseTimeUnit();

    private String getBaseTimeUnitStr() {
        if (this.getBaseTimeUnit() == null) {
            return null;
        }
        return this.getBaseTimeUnit().toString().toLowerCase();
    }

    Counter counter(Meter.Id id) {
        return this.registerMeterIfNecessary(Counter.class, id, id2 -> {
            id2.setType(Meter.Type.Counter);
            return this.newCounter((Meter.Id)id2);
        }, NoopCounter::new);
    }

    <T> Gauge gauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        return this.registerMeterIfNecessary(Gauge.class, id, id2 -> {
            id2.setType(Meter.Type.Gauge);
            return this.newGauge((Meter.Id)id2, obj, f);
        }, NoopGauge::new);
    }

    Timer timer(Meter.Id id, HistogramConfig histogramConfig) {
        return this.registerMeterIfNecessary(Timer.class, id, histogramConfig, (id2, filteredConfig) -> {
            id2.setType(Meter.Type.Timer);
            return this.newTimer((Meter.Id)id2, filteredConfig.merge(HistogramConfig.DEFAULT));
        }, NoopTimer::new);
    }

    DistributionSummary summary(Meter.Id id, HistogramConfig histogramConfig) {
        return this.registerMeterIfNecessary(DistributionSummary.class, id, histogramConfig, (id2, filteredConfig) -> {
            id2.setType(Meter.Type.DistributionSummary);
            return this.newDistributionSummary((Meter.Id)id2, filteredConfig.merge(HistogramConfig.DEFAULT));
        }, NoopDistributionSummary::new);
    }

    Meter register(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return this.registerMeterIfNecessary(Meter.class, id, id2 -> {
            id2.setType(type);
            this.newMeter((Meter.Id)id2, type, measurements);
            return new Meter((Meter.Id)id2, type, measurements){
                final /* synthetic */ Meter.Id val$id2;
                final /* synthetic */ Meter.Type val$type;
                final /* synthetic */ Iterable val$measurements;
                {
                    this.val$id2 = id;
                    this.val$type = type;
                    this.val$measurements = iterable;
                }

                @Override
                public Meter.Id getId() {
                    return this.val$id2;
                }

                @Override
                public Meter.Type getType() {
                    return this.val$type;
                }

                @Override
                public Iterable<Measurement> measure() {
                    return this.val$measurements;
                }
            };
        }, NoopMeter::new);
    }

    public Collection<Meter> getMeters() {
        return this.meterMap.values();
    }

    public Config config() {
        return this.config;
    }

    public Search find(String name) {
        return new Search(name);
    }

    public Counter counter(String name, Iterable<Tag> tags) {
        return this.counter(this.createId(name, tags, null));
    }

    public Counter counter(String name, String ... tags) {
        return this.counter(name, Tags.zip(tags));
    }

    public DistributionSummary summary(String name, Iterable<Tag> tags) {
        return this.summary(this.createId(name, tags, null), HistogramConfig.DEFAULT);
    }

    public DistributionSummary summary(String name, String ... tags) {
        return this.summary(name, Tags.zip(tags));
    }

    public Timer timer(String name, Iterable<Tag> tags) {
        return this.timer(this.createId(name, tags, null), HistogramConfig.DEFAULT);
    }

    public Timer timer(String name, String ... tags) {
        return this.timer(name, Tags.zip(tags));
    }

    public More more() {
        return this.more;
    }

    public <T> T gauge(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f) {
        this.gauge(this.createId(name, tags, null), obj, f);
        return obj;
    }

    public <T extends Number> T gauge(String name, Iterable<Tag> tags, T number) {
        return (T)this.gauge(name, tags, number, Number::doubleValue);
    }

    public <T extends Number> T gauge(String name, T number) {
        return this.gauge(name, Collections.emptyList(), number);
    }

    public <T> T gauge(String name, T obj, ToDoubleFunction<T> f) {
        return this.gauge(name, Collections.emptyList(), obj, f);
    }

    public <T extends Collection<?>> T gaugeCollectionSize(String name, Iterable<Tag> tags, T collection) {
        return (T)this.gauge(name, tags, collection, Collection::size);
    }

    public <T extends Map<?, ?>> T gaugeMapSize(String name, Iterable<Tag> tags, T map) {
        return (T)this.gauge(name, tags, map, Map::size);
    }

    private Meter.Id createId(String name, Iterable<Tag> tags, String description) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name must be non-empty");
        }
        return new Meter.Id(name, tags, description, null);
    }

    private <M extends Meter> M registerMeterIfNecessary(Class<M> meterClass, Meter.Id id, Function<Meter.Id, Meter> builder, Function<Meter.Id, M> noopBuilder) {
        return this.registerMeterIfNecessary(meterClass, id, null, (id2, conf) -> (Meter)builder.apply((Meter.Id)id2), noopBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private <M extends Meter> M registerMeterIfNecessary(Class<M> meterClass, Meter.Id id, HistogramConfig config, BiFunction<Meter.Id, HistogramConfig, Meter> builder, Function<Meter.Id, M> noopBuilder) {
        void var8_14;
        Meter meter;
        Meter.Id mappedId = id;
        for (MeterFilter meterFilter : this.filters) {
            mappedId = meterFilter.map(mappedId);
        }
        if (!this.accept(id)) {
            return (M)((Meter)noopBuilder.apply(id));
        }
        HistogramConfig mappedConfig = config;
        if (mappedConfig != null) {
            for (MeterFilter filter : this.filters) {
                mappedConfig = filter.configure(mappedId, mappedConfig);
            }
        }
        if ((meter = this.meterMap.get(mappedId)) == null) {
            Map<Meter.Id, Meter> map = this.meterMap;
            synchronized (map) {
                Meter meter2 = builder.apply(mappedId, mappedConfig);
                Meter m2 = this.meterMap.putIfAbsent(mappedId, meter2);
                Meter meter3 = m2 == null ? meter2 : m2;
            }
        }
        if (!meterClass.isInstance(var8_14)) {
            throw new IllegalArgumentException("There is already a registered meter of a different type with the same name");
        }
        return var8_14;
    }

    private boolean accept(Meter.Id id) {
        for (MeterFilter filter : this.filters) {
            switch (filter.accept(id)) {
                case DENY: {
                    return false;
                }
                case ACCEPT: {
                    return true;
                }
            }
        }
        return true;
    }

    public class More {
        public LongTaskTimer longTaskTimer(String name, String ... tags) {
            return this.longTaskTimer(name, Tags.zip(tags));
        }

        public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
            return this.longTaskTimer(MeterRegistry.this.createId(name, tags, null));
        }

        LongTaskTimer longTaskTimer(Meter.Id id) {
            return (LongTaskTimer)MeterRegistry.this.registerMeterIfNecessary(LongTaskTimer.class, id, id2 -> {
                id2.setType(Meter.Type.LongTaskTimer);
                id2.setBaseUnit(MeterRegistry.this.getBaseTimeUnitStr());
                return MeterRegistry.this.newLongTaskTimer((Meter.Id)id2);
            }, NoopLongTaskTimer::new);
        }

        public <T> FunctionCounter counter(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f) {
            return this.counter(MeterRegistry.this.createId(name, tags, null), obj, f);
        }

        public <T extends Number> FunctionCounter counter(String name, Iterable<Tag> tags, T number) {
            return this.counter(MeterRegistry.this.createId(name, tags, null), number, Number::doubleValue);
        }

        <T> FunctionCounter counter(Meter.Id id, T obj, final ToDoubleFunction<T> f) {
            final WeakReference ref = new WeakReference(obj);
            return (FunctionCounter)MeterRegistry.this.registerMeterIfNecessary(FunctionCounter.class, id, id2 -> {
                id2.setType(Meter.Type.Counter);
                FunctionCounter fc = new FunctionCounter((Meter.Id)id2){
                    private volatile double last = 0.0;
                    final /* synthetic */ Meter.Id val$id2;
                    {
                        this.val$id2 = id;
                    }

                    @Override
                    public double count() {
                        Object obj2 = ref.get();
                        return obj2 != null ? (this.last = f.applyAsDouble(obj2)) : this.last;
                    }

                    @Override
                    public Meter.Id getId() {
                        return this.val$id2;
                    }
                };
                MeterRegistry.this.newMeter((Meter.Id)id2, Meter.Type.Counter, fc.measure());
                return fc;
            }, NoopFunctionCounter::new);
        }

        public <T> FunctionTimer timer(String name, Iterable<Tag> tags, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
            return this.timer(MeterRegistry.this.createId(name, tags, null), obj, countFunction, totalTimeFunction, totalTimeFunctionUnits);
        }

        <T> FunctionTimer timer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
            return (FunctionTimer)MeterRegistry.this.registerMeterIfNecessary(FunctionTimer.class, id, id2 -> {
                id2.setType(Meter.Type.Timer);
                id2.setBaseUnit(MeterRegistry.this.getBaseTimeUnitStr());
                return MeterRegistry.this.newFunctionTimer((Meter.Id)id2, obj, countFunction, totalTimeFunction, totalTimeFunctionUnits);
            }, NoopFunctionTimer::new);
        }

        public <T> TimeGauge timeGauge(String name, Iterable<Tag> tags, T obj, TimeUnit fUnit, ToDoubleFunction<T> f) {
            return this.timeGauge(MeterRegistry.this.createId(name, tags, null), obj, fUnit, f);
        }

        <T> TimeGauge timeGauge(Meter.Id id, T obj, TimeUnit fUnit, ToDoubleFunction<T> f) {
            return (TimeGauge)MeterRegistry.this.registerMeterIfNecessary(TimeGauge.class, id, id2 -> {
                id2.setType(Meter.Type.Gauge);
                return MeterRegistry.this.newTimeGauge((Meter.Id)id2, obj, fUnit, f);
            }, NoopTimeGauge::new);
        }
    }

    public class Search {
        private final String name;
        private List<Tag> tags = new ArrayList<Tag>();
        private Map<Statistic, Double> valueAsserts = new HashMap<Statistic, Double>();

        Search(String name) {
            this.name = name;
        }

        public Search tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        public Search tags(String ... tags) {
            return this.tags(Tags.zip(tags));
        }

        public Search value(Statistic statistic, double value) {
            this.valueAsserts.put(statistic, value);
            return this;
        }

        public Optional<Timer> timer() {
            return this.meters().stream().filter(m -> m instanceof Timer).findAny().map(Timer.class::cast);
        }

        public Optional<Counter> counter() {
            return this.meters().stream().filter(m -> m instanceof Counter).findAny().map(Counter.class::cast);
        }

        public Optional<Gauge> gauge() {
            return this.meters().stream().filter(m -> m instanceof Gauge).findAny().map(Gauge.class::cast);
        }

        public Optional<DistributionSummary> summary() {
            return this.meters().stream().filter(m -> m instanceof DistributionSummary).findAny().map(DistributionSummary.class::cast);
        }

        public Optional<LongTaskTimer> longTaskTimer() {
            return this.meters().stream().filter(m -> m instanceof LongTaskTimer).findAny().map(LongTaskTimer.class::cast);
        }

        public Optional<Meter> meter() {
            return this.meters().stream().findAny();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<Meter> meters() {
            Map map = MeterRegistry.this.meterMap;
            synchronized (map) {
                return MeterRegistry.this.meterMap.keySet().stream().filter(id -> id.getName().equals(this.name)).filter(id -> {
                    if (this.tags.isEmpty()) {
                        return true;
                    }
                    ArrayList idTags = new ArrayList();
                    id.getTags().forEach(idTags::add);
                    return idTags.containsAll(this.tags);
                }).map(MeterRegistry.this.meterMap::get).filter(m -> {
                    if (this.valueAsserts.isEmpty()) {
                        return true;
                    }
                    for (Measurement measurement : m.measure()) {
                        if (!this.valueAsserts.containsKey((Object)measurement.getStatistic()) || !(Math.abs(this.valueAsserts.get((Object)measurement.getStatistic()) - measurement.getValue()) > 1.0E-7)) continue;
                        return false;
                    }
                    return true;
                }).collect(Collectors.toList());
            }
        }
    }

    public class Config {
        public Config commonTags(Iterable<Tag> tags) {
            this.meterFilter(MeterFilter.commonTags(tags));
            return this;
        }

        public Config commonTags(String ... tags) {
            return this.commonTags(Tags.zip(tags));
        }

        @Incubating(since="1.0.0-rc.3")
        public Config meterFilter(MeterFilter filter) {
            MeterRegistry.this.filters.add(filter);
            return this;
        }

        public Config namingConvention(NamingConvention convention) {
            MeterRegistry.this.namingConvention = convention;
            return this;
        }

        public NamingConvention namingConvention() {
            return MeterRegistry.this.namingConvention;
        }

        public Clock clock() {
            return MeterRegistry.this.clock;
        }
    }
}

