/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public interface FunctionTimer
extends Meter {
    public long count();

    public double totalTime(TimeUnit var1);

    default public double mean(TimeUnit unit) {
        return this.count() == 0L ? 0.0 : this.totalTime(unit) / (double)this.count();
    }

    public TimeUnit baseTimeUnit();

    @Override
    default public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.Count), new Measurement(() -> this.totalTime(this.baseTimeUnit()), Statistic.TotalTime));
    }

    public static <T> Builder<T> builder(String name, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
        return new Builder(name, obj, countFunction, totalTimeFunction, totalTimeFunctionUnits);
    }

    public static class Builder<T> {
        private final String name;
        private final T obj;
        private final ToLongFunction<T> countFunction;
        private final ToDoubleFunction<T> totalTimeFunction;
        private final TimeUnit totalTimeFunctionUnits;
        private final List<Tag> tags = new ArrayList<Tag>();
        private String description;
        private String baseUnit;

        private Builder(String name, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
            this.name = name;
            this.obj = obj;
            this.countFunction = countFunction;
            this.totalTimeFunction = totalTimeFunction;
            this.totalTimeFunctionUnits = totalTimeFunctionUnits;
        }

        public Builder<T> tags(String ... tags) {
            return this.tags(Tags.zip(tags));
        }

        public Builder<T> tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        public Builder<T> description(String description) {
            this.description = description;
            return this;
        }

        public Builder<T> baseUnit(String unit) {
            this.baseUnit = unit;
            return this;
        }

        public FunctionTimer register(MeterRegistry registry) {
            return registry.more().timer(new Meter.Id(this.name, this.tags, this.baseUnit, this.description), this.obj, this.countFunction, this.totalTimeFunction, this.totalTimeFunctionUnits);
        }
    }
}

