/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.stats.hist;

import io.micrometer.core.instrument.stats.hist.Bucket;
import io.micrometer.core.instrument.stats.hist.BucketFilter;
import io.micrometer.core.instrument.stats.hist.BucketFunction;
import io.micrometer.core.instrument.stats.hist.Histogram;
import java.util.Collection;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DefaultHistogram<T>
implements Histogram<T> {
    protected final NavigableMap<T, Bucket<T>> buckets;
    private final BucketFunction<? extends T> f;
    private final Histogram.Summation summation;
    private final Collection<BucketFilter<T>> domainFilters;

    DefaultHistogram(BucketFunction<T> f, Collection<BucketFilter<T>> domainFilters, Histogram.Summation summation) {
        this.f = f;
        this.summation = summation;
        this.domainFilters = domainFilters;
        this.buckets = f.buckets().stream().collect(Collectors.toMap(Bucket::getTag, Function.identity(), (u, v) -> u, TreeMap::new));
    }

    @Override
    public Collection<Bucket<T>> getBuckets() {
        if (this.domainFilters.isEmpty()) {
            return this.buckets.values();
        }
        return this.buckets.values().stream().filter(bucket -> this.isCumulative() && bucket.getTag().equals(Double.POSITIVE_INFINITY) || this.domainFilters.stream().allMatch(filter -> filter.shouldPublish(bucket))).collect(Collectors.toList());
    }

    @Override
    public Bucket<T> getBucket(T tag) {
        return (Bucket)this.buckets.get(tag);
    }

    @Override
    public void observe(double value) {
        T tag = this.f.bucket(value);
        Bucket bucket = (Bucket)this.buckets.get(tag);
        if (bucket != null) {
            bucket.increment();
        }
        if (this.isCumulative()) {
            this.buckets.tailMap(tag, false).forEach((tailTag, tailBucket) -> tailBucket.increment());
        }
    }

    @Override
    public boolean isCumulative() {
        return Histogram.Summation.Cumulative.equals((Object)this.summation);
    }

    public static class Builder<U>
    extends Histogram.Builder<U> {
        Builder(BucketFunction<U> f) {
            super(f);
        }

        @Override
        public Builder<U> summation(Histogram.Summation summation) {
            return (Builder)super.summation(summation);
        }

        @Override
        public Builder<U> filterBuckets(BucketFilter<U> filter) {
            return (Builder)super.filterBuckets(filter);
        }

        @Override
        public DefaultHistogram<U> create(Histogram.Summation defaultSummationMode) {
            return new DefaultHistogram(this.f, this.domainFilters, this.summation == null ? defaultSummationMode : this.summation);
        }
    }
}

