/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.cache;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.ArrayList;
import javax.cache.Cache;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class JCacheMetrics
implements MeterBinder {
    private ObjectName objectName;
    private final String name;
    private final Iterable<Tag> tags;

    public static <K, V, C extends Cache<K, V>> C monitor(MeterRegistry registry, C cache, String name, String ... tags) {
        return JCacheMetrics.monitor(registry, cache, name, Tags.zip(tags));
    }

    public static <K, V, C extends Cache<K, V>> C monitor(MeterRegistry registry, C cache, String name, Iterable<Tag> tags) {
        new JCacheMetrics(cache, name, tags).bindTo(registry);
        return cache;
    }

    public JCacheMetrics(Cache<?, ?> cache, String name, Iterable<Tag> tags) {
        try {
            String cacheManagerUri = cache.getCacheManager().getURI().toString().replace(':', '.');
            this.objectName = new ObjectName("javax.cache:type=CacheStatistics,CacheManager=" + cacheManagerUri + ",Cache=" + cache.getName());
        }
        catch (MalformedObjectNameException ignored) {
            throw new IllegalStateException("Cache name '" + cache.getName() + "' results in an invalid JMX name");
        }
        this.name = name;
        this.tags = Tags.concat(tags, "name", cache.getName());
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        registry.gauge(registry.createId(this.name + ".requests", Tags.concat(this.tags, "result", "hit"), "The number of times cache lookup methods have returned a cached value"), this.objectName, CacheStatistics.CacheHits::get);
        registry.gauge(registry.createId(this.name + ".requests", Tags.concat(this.tags, "result", "miss"), "The number of times cache lookup methods have not returned a value"), this.objectName, CacheStatistics.CacheMisses::get);
        registry.gauge(registry.createId(this.name + ".puts", this.tags, "Cache puts"), this.objectName, CacheStatistics.CachePuts::get);
        registry.gauge(registry.createId(this.name + ".removals", this.tags, "Cache removals"), this.objectName, CacheStatistics.CacheRemovals::get);
        registry.gauge(registry.createId(this.name + ".evictions", this.tags, "Cache evictions"), this.objectName, CacheStatistics.CacheEvictions::get);
    }

    private static enum CacheStatistics {
        CacheHits,
        CacheHitPercentage,
        CacheMisses,
        CacheMissPercentage,
        CacheGets,
        CachePuts,
        CacheRemovals,
        CacheEvictions,
        AverageGetTime,
        AveragePutTime,
        AverageRemoveTime;


        public long get(ObjectName objectName) {
            try {
                ArrayList<MBeanServer> mBeanServers = MBeanServerFactory.findMBeanServer(null);
                System.out.println("There are " + mBeanServers.size() + " MBean servers");
                for (MBeanServer mBeanServer : mBeanServers) {
                    try {
                        Object attribute = mBeanServer.getAttribute(objectName, this.toString());
                        return (Long)attribute;
                    }
                    catch (AttributeNotFoundException | InstanceNotFoundException operationsException) {
                    }
                }
            }
            catch (MBeanException | ReflectionException ex) {
                throw new IllegalStateException(ex);
            }
            return 0L;
        }
    }
}

