/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.cache;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.statistics.StatisticsGateway;

public class EhCache2Metrics
implements MeterBinder {
    private final String name;
    private final Iterable<Tag> tags;
    private final StatisticsGateway stats;

    public static Ehcache monitor(MeterRegistry registry, Ehcache cache, String name, String ... tags) {
        return EhCache2Metrics.monitor(registry, cache, name, Tags.zip(tags));
    }

    public static Ehcache monitor(MeterRegistry registry, Ehcache cache, String name, Iterable<Tag> tags) {
        new EhCache2Metrics(cache, name, tags).bindTo(registry);
        return cache;
    }

    public EhCache2Metrics(Ehcache cache, String name, Iterable<Tag> tags) {
        this.stats = cache.getStatistics();
        this.name = name;
        this.tags = Tags.concat(tags, "name", cache.getName());
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        registry.gauge(registry.createId(this.name + ".size", Tags.concat(this.tags, "where", "local"), "The number of entries held locally in this cache"), this.stats, StatisticsGateway::getSize);
        registry.gauge(registry.createId(this.name + ".size", Tags.concat(this.tags, "where", "remote"), "The number of entries held remotely in this cache"), this.stats, StatisticsGateway::getRemoteSize);
        registry.more().counter(registry.createId(this.name + ".evictions", this.tags, "Cache evictions"), this.stats, StatisticsGateway::cacheEvictedCount);
        registry.more().counter(registry.createId(this.name + ".removals", this.tags, "Cache removals"), this.stats, StatisticsGateway::cacheRemoveCount);
        registry.more().counter(registry.createId(this.name + ".puts", Tags.concat(this.tags, "result", "added"), "Cache puts resulting in a new key/value pair"), this.stats, StatisticsGateway::cachePutAddedCount);
        registry.more().counter(registry.createId(this.name + ".puts", Tags.concat(this.tags, "result", "updated"), "Cache puts resulting in an updated value"), this.stats, StatisticsGateway::cachePutAddedCount);
        this.requestMetrics(registry);
        this.commitTransactionMetrics(registry);
        this.rollbackTransactionMetrics(registry);
        this.recoveryTransactionMetrics(registry);
        registry.gauge(registry.createId(this.name + ".local.offheap.size", this.tags, "Local off-heap size", "bytes"), this.stats, StatisticsGateway::getLocalOffHeapSize);
        registry.gauge(registry.createId(this.name + ".local.heap.size", this.tags, "Local heap size", "bytes"), this.stats, StatisticsGateway::getLocalHeapSizeInBytes);
        registry.gauge(registry.createId(this.name + ".local.disk.size", this.tags, "Local disk size", "bytes"), this.stats, StatisticsGateway::getLocalDiskSizeInBytes);
    }

    private void requestMetrics(MeterRegistry registry) {
        registry.more().counter(registry.createId(this.name + ".requests", Tags.concat(this.tags, "result", "miss", "reason", "expired"), "The number of times cache lookup methods have not returned a value, due to expiry"), this.stats, StatisticsGateway::cacheMissExpiredCount);
        registry.more().counter(registry.createId(this.name + ".requests", Tags.concat(this.tags, "result", "miss", "reason", "notFound"), "The number of times cache lookup methods have not returned a value, because the key was not found"), this.stats, StatisticsGateway::cacheMissNotFoundCount);
        registry.more().counter(registry.createId(this.name + ".requests", Tags.concat(this.tags, "result", "hit"), "The number of times cache lookup methods have returned a cached value."), this.stats, StatisticsGateway::cacheHitCount);
    }

    private void commitTransactionMetrics(MeterRegistry registry) {
        registry.more().counter(registry.createId(this.name + ".xa.commits", Tags.concat(this.tags, "result", "readOnly"), "Transaction commits that had a read-only result"), this.stats, StatisticsGateway::xaCommitReadOnlyCount);
        registry.more().counter(registry.createId(this.name + ".xa.commits", Tags.concat(this.tags, "result", "exception"), "Transaction commits that failed"), this.stats, StatisticsGateway::xaCommitExceptionCount);
        registry.more().counter(registry.createId(this.name + ".xa.commits", Tags.concat(this.tags, "result", "committed"), "Transaction commits that failed"), this.stats, StatisticsGateway::xaCommitCommittedCount);
    }

    private void rollbackTransactionMetrics(MeterRegistry registry) {
        registry.more().counter(registry.createId(this.name + ".xa.rollbacks", Tags.concat(this.tags, "result", "exception"), "Transaction rollbacks that failed"), this.stats, StatisticsGateway::xaRollbackExceptionCount);
        registry.more().counter(registry.createId(this.name + ".xa.rollbacks", Tags.concat(this.tags, "result", "success"), "Transaction rollbacks that failed"), this.stats, StatisticsGateway::xaRollbackSuccessCount);
    }

    private void recoveryTransactionMetrics(MeterRegistry registry) {
        registry.more().counter(registry.createId(this.name + ".xa.recoveries", Tags.concat(this.tags, "result", "nothing"), "Recovery transactions that recovered nothing"), this.stats, StatisticsGateway::xaRecoveryNothingCount);
        registry.more().counter(registry.createId(this.name + ".xa.recoveries", Tags.concat(this.tags, "result", "success"), "Successful recovery transaction"), this.stats, StatisticsGateway::xaRecoveryRecoveredCount);
    }
}

