/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.NamingConvention;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import java.beans.Introspector;
import java.util.List;

public interface Meter {
    public Id getId();

    public Iterable<Measurement> measure();

    default public Type getType() {
        return Type.Other;
    }

    public static interface Id {
        public String getName();

        public Iterable<Tag> getTags();

        public String getBaseUnit();

        public String getDescription();

        public String getConventionName(NamingConvention var1);

        public List<Tag> getConventionTags(NamingConvention var1);

        public Id withTag(Tag var1);

        default public Id withTag(Statistic statistic) {
            if (statistic == null) {
                return this;
            }
            return this.withTag(Tag.of("statistic", Introspector.decapitalize(statistic.toString())));
        }

        public void setType(Type var1);

        public void setBaseUnit(String var1);
    }

    public static enum Type {
        Counter,
        Gauge,
        LongTaskTimer,
        Timer,
        DistributionSummary,
        Other;

    }
}

