/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.NamingConvention;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.internal.DefaultFunctionTimer;
import io.micrometer.core.instrument.internal.MeterId;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.micrometer.core.instrument.util.TimeUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public abstract class AbstractMeterRegistry
implements MeterRegistry {
    protected final Clock clock;
    private final List<Tag> commonTags = new ArrayList<Tag>();
    private final Map<Meter.Id, Meter> meterMap = new HashMap<Meter.Id, Meter>();
    private NamingConvention namingConvention = NamingConvention.snakeCase;
    private MeterRegistry.Config config = new MeterRegistry.Config(){

        @Override
        public MeterRegistry.Config commonTags(Iterable<Tag> tags) {
            StreamSupport.stream(tags.spliterator(), false).map(t -> Tag.of(AbstractMeterRegistry.this.namingConvention.tagKey(t.getKey()), AbstractMeterRegistry.this.namingConvention.tagValue(t.getValue()))).forEach(AbstractMeterRegistry.this.commonTags::add);
            return this;
        }

        @Override
        public Iterable<Tag> commonTags() {
            return AbstractMeterRegistry.this.commonTags;
        }

        @Override
        public MeterRegistry.Config namingConvention(NamingConvention convention) {
            AbstractMeterRegistry.this.namingConvention = convention;
            return this;
        }

        @Override
        public NamingConvention namingConvention() {
            return AbstractMeterRegistry.this.namingConvention;
        }

        @Override
        public Clock clock() {
            return AbstractMeterRegistry.this.clock;
        }
    };
    private MeterRegistry.More more = new MeterRegistry.More(){

        @Override
        public LongTaskTimer longTaskTimer(Meter.Id id) {
            return (LongTaskTimer)AbstractMeterRegistry.this.registerMeterIfNecessary(LongTaskTimer.class, id, id2 -> {
                id2.setType(Meter.Type.LongTaskTimer);
                id2.setBaseUnit(AbstractMeterRegistry.this.getBaseTimeUnitStr());
                return AbstractMeterRegistry.this.newLongTaskTimer((Meter.Id)id2);
            });
        }

        public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
            return this.longTaskTimer(AbstractMeterRegistry.this.createId(name, tags, null));
        }

        @Override
        public <T> FunctionCounter counter(Meter.Id id, T obj, final ToDoubleFunction<T> f) {
            final WeakReference ref = new WeakReference(obj);
            return (FunctionCounter)AbstractMeterRegistry.this.registerMeterIfNecessary(FunctionCounter.class, id, id2 -> {
                id2.setType(Meter.Type.Counter);
                FunctionCounter fc = new FunctionCounter((Meter.Id)id2){
                    private volatile double last = 0.0;
                    final /* synthetic */ Meter.Id val$id2;
                    {
                        this.val$id2 = id;
                    }

                    @Override
                    public double count() {
                        Object obj2 = ref.get();
                        return obj2 != null ? (this.last = f.applyAsDouble(obj2)) : this.last;
                    }

                    @Override
                    public Meter.Id getId() {
                        return this.val$id2;
                    }
                };
                AbstractMeterRegistry.this.newMeter((Meter.Id)id2, Meter.Type.Counter, fc.measure());
                return fc;
            });
        }

        @Override
        public <T> FunctionTimer timer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
            return (FunctionTimer)AbstractMeterRegistry.this.registerMeterIfNecessary(FunctionTimer.class, id, id2 -> {
                id2.setType(Meter.Type.Timer);
                return AbstractMeterRegistry.this.newFunctionTimer((Meter.Id)id2, obj, countFunction, totalTimeFunction, totalTimeFunctionUnits);
            });
        }

        @Override
        public <T> Gauge timeGauge(Meter.Id id, T obj, TimeUnit fUnit, ToDoubleFunction<T> f) {
            return (Gauge)AbstractMeterRegistry.this.registerMeterIfNecessary(Gauge.class, id, id2 -> {
                id2.setType(Meter.Type.Gauge);
                return AbstractMeterRegistry.this.newTimeGauge((Meter.Id)id2, obj, fUnit, f);
            });
        }
    };

    @Override
    public MeterRegistry.Config config() {
        return this.config;
    }

    public AbstractMeterRegistry(Clock clock) {
        this.clock = clock;
    }

    protected abstract <T> Gauge newGauge(Meter.Id var1, T var2, ToDoubleFunction<T> var3);

    protected abstract Counter newCounter(Meter.Id var1);

    protected abstract LongTaskTimer newLongTaskTimer(Meter.Id var1);

    protected abstract Timer newTimer(Meter.Id var1, Histogram.Builder<?> var2, Quantiles var3);

    protected abstract DistributionSummary newDistributionSummary(Meter.Id var1, Histogram.Builder<?> var2, Quantiles var3);

    protected abstract void newMeter(Meter.Id var1, Meter.Type var2, Iterable<Measurement> var3);

    protected <T> Gauge newTimeGauge(Meter.Id id, T obj, TimeUnit fUnit, ToDoubleFunction<T> f) {
        id.setBaseUnit(this.getBaseTimeUnitStr());
        return this.newGauge(id, obj, obj2 -> TimeUtils.convert(f.applyAsDouble(obj2), fUnit, this.getBaseTimeUnit()));
    }

    protected <T> Meter newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
        id.setBaseUnit(this.getBaseTimeUnitStr());
        DefaultFunctionTimer<T> ft = new DefaultFunctionTimer<T>(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnits, this.getBaseTimeUnit());
        this.newMeter(id, Meter.Type.Timer, ft.measure());
        return ft;
    }

    protected List<Tag> getConventionTags(Meter.Id id) {
        return id.getConventionTags(this.config().namingConvention());
    }

    protected String getConventionName(Meter.Id id) {
        return id.getConventionName(this.config().namingConvention());
    }

    protected abstract TimeUnit getBaseTimeUnit();

    private String getBaseTimeUnitStr() {
        if (this.getBaseTimeUnit() == null) {
            return null;
        }
        return this.getBaseTimeUnit().toString().toLowerCase();
    }

    @Override
    public Meter register(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return this.registerMeterIfNecessary(Meter.class, id, id2 -> {
            id2.setType(type);
            this.newMeter((Meter.Id)id2, type, measurements);
            return new Meter((Meter.Id)id2, type, measurements){
                final /* synthetic */ Meter.Id val$id2;
                final /* synthetic */ Meter.Type val$type;
                final /* synthetic */ Iterable val$measurements;
                {
                    this.val$id2 = id;
                    this.val$type = type;
                    this.val$measurements = iterable;
                }

                @Override
                public Meter.Id getId() {
                    return this.val$id2;
                }

                @Override
                public Meter.Type getType() {
                    return this.val$type;
                }

                @Override
                public Iterable<Measurement> measure() {
                    return this.val$measurements;
                }
            };
        });
    }

    @Override
    public Counter counter(Meter.Id id) {
        return this.registerMeterIfNecessary(Counter.class, id, id2 -> {
            id2.setType(Meter.Type.Counter);
            return this.newCounter((Meter.Id)id2);
        });
    }

    @Override
    public <T> Gauge gauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        return this.registerMeterIfNecessary(Gauge.class, id, id2 -> {
            id2.setType(Meter.Type.Gauge);
            return this.newGauge((Meter.Id)id2, obj, f);
        });
    }

    @Override
    public Timer timer(Meter.Id id, Histogram.Builder<?> histogram, Quantiles quantiles) {
        return this.registerMeterIfNecessary(Timer.class, id, id2 -> {
            id2.setType(Meter.Type.Timer);
            return this.newTimer((Meter.Id)id2, histogram, quantiles);
        });
    }

    @Override
    public DistributionSummary summary(Meter.Id id, Histogram.Builder<?> histogram, Quantiles quantiles) {
        return this.registerMeterIfNecessary(DistributionSummary.class, id, id2 -> {
            id2.setType(Meter.Type.DistributionSummary);
            return this.newDistributionSummary((Meter.Id)id2, histogram, quantiles);
        });
    }

    @Override
    public MeterRegistry.More more() {
        return this.more;
    }

    @Override
    public MeterRegistry.Search find(String name) {
        return new SearchImpl(name);
    }

    @Override
    public Collection<Meter> getMeters() {
        return this.meterMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <M extends Meter> M registerMeterIfNecessary(Class<M> meterClass, Meter.Id id, Function<Meter.Id, Meter> builder) {
        MeterId idWithCommonTags = new MeterId(id.getName(), Tags.concat(id.getTags(), this.config().commonTags()), id.getBaseUnit(), id.getDescription());
        Meter m = this.meterMap.get(idWithCommonTags);
        if (m == null) {
            m = builder.apply(idWithCommonTags);
            Map<Meter.Id, Meter> map = this.meterMap;
            synchronized (map) {
                Meter m2 = this.meterMap.putIfAbsent(idWithCommonTags, m);
                m = m2 == null ? m : m2;
            }
        }
        if (!meterClass.isInstance(m)) {
            throw new IllegalArgumentException("There is already a registered meter of a different type with the same name");
        }
        return (M)m;
    }

    @Override
    public Meter.Id createId(String name, Iterable<Tag> tags, String description, String baseUnit) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name must be non-empty");
        }
        return new MeterId(name, Tags.concat(tags, this.config().commonTags()), baseUnit, description);
    }

    private class SearchImpl
    implements MeterRegistry.Search {
        private final String name;
        private List<Tag> tags = new ArrayList<Tag>();
        private Map<Statistic, Double> valueAsserts = new HashMap<Statistic, Double>();

        SearchImpl(String name) {
            this.name = name;
        }

        @Override
        public MeterRegistry.Search tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        @Override
        public MeterRegistry.Search value(Statistic statistic, double value) {
            this.valueAsserts.put(statistic, value);
            return this;
        }

        @Override
        public Optional<Timer> timer() {
            return this.meters().stream().filter(m -> m instanceof Timer).findAny().map(Timer.class::cast);
        }

        @Override
        public Optional<Counter> counter() {
            return this.meters().stream().filter(m -> m instanceof Counter).findAny().map(Counter.class::cast);
        }

        @Override
        public Optional<Gauge> gauge() {
            return this.meters().stream().filter(m -> m instanceof Gauge).findAny().map(Gauge.class::cast);
        }

        @Override
        public Optional<DistributionSummary> summary() {
            return this.meters().stream().filter(m -> m instanceof DistributionSummary).findAny().map(DistributionSummary.class::cast);
        }

        @Override
        public Optional<LongTaskTimer> longTaskTimer() {
            return this.meters().stream().filter(m -> m instanceof LongTaskTimer).findAny().map(LongTaskTimer.class::cast);
        }

        @Override
        public Optional<Meter> meter() {
            return this.meters().stream().findAny();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<Meter> meters() {
            Map map = AbstractMeterRegistry.this.meterMap;
            synchronized (map) {
                return AbstractMeterRegistry.this.meterMap.keySet().stream().filter(id -> id.getName().equals(this.name)).filter(id -> {
                    if (this.tags.isEmpty()) {
                        return true;
                    }
                    ArrayList idTags = new ArrayList();
                    id.getTags().forEach(idTags::add);
                    return idTags.containsAll(this.tags);
                }).map(AbstractMeterRegistry.this.meterMap::get).filter(m -> {
                    if (this.valueAsserts.isEmpty()) {
                        return true;
                    }
                    for (Measurement measurement : m.measure()) {
                        if (!this.valueAsserts.containsKey((Object)measurement.getStatistic()) || !(Math.abs(this.valueAsserts.get((Object)measurement.getStatistic()) - measurement.getValue()) > 1.0E-7)) continue;
                        return false;
                    }
                    return true;
                }).collect(Collectors.toList());
            }
        }
    }
}

