/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.dropwizard;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import io.micrometer.core.instrument.AbstractMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.NamingConvention;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.dropwizard.DropwizardCounter;
import io.micrometer.core.instrument.dropwizard.DropwizardDistributionSummary;
import io.micrometer.core.instrument.dropwizard.DropwizardGauge;
import io.micrometer.core.instrument.dropwizard.DropwizardTimer;
import io.micrometer.core.instrument.simple.SimpleLongTaskTimer;
import io.micrometer.core.instrument.stats.hist.Bucket;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.core.instrument.util.TimeUtils;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;

public class DropwizardMeterRegistry
extends AbstractMeterRegistry {
    private final MetricRegistry registry = new MetricRegistry();
    private final HierarchicalNameMapper nameMapper;

    public DropwizardMeterRegistry(HierarchicalNameMapper nameMapper, Clock clock) {
        super(clock);
        this.nameMapper = nameMapper;
        this.config().namingConvention(NamingConvention.camelCase);
    }

    public MetricRegistry getDropwizardRegistry() {
        return this.registry;
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        return new DropwizardCounter(id, this.registry.meter(this.hierarchicalName(id)));
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        WeakReference ref = new WeakReference(obj);
        com.codahale.metrics.Gauge gauge = () -> {
            Object obj2 = ref.get();
            return obj2 != null ? f.applyAsDouble(ref.get()) : Double.NaN;
        };
        this.registry.register(this.hierarchicalName(id), (Metric)gauge);
        return new DropwizardGauge(id, (com.codahale.metrics.Gauge<Double>)gauge);
    }

    @Override
    protected Timer newTimer(Meter.Id id, Histogram.Builder<?> histogram, Quantiles quantiles) {
        id.setBaseUnit("nanoseconds");
        this.registerQuantilesGaugeIfNecessary(id, quantiles);
        return new DropwizardTimer(id, this.registry.timer(this.hierarchicalName(id)), this.clock, quantiles, this.registerHistogramCounterIfNecessary(id, histogram));
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, Histogram.Builder<?> histogram, Quantiles quantiles) {
        this.registerQuantilesGaugeIfNecessary(id, quantiles);
        return new DropwizardDistributionSummary(id, this.registry.histogram(this.hierarchicalName(id)), quantiles, this.registerHistogramCounterIfNecessary(id, histogram));
    }

    private void registerQuantilesGaugeIfNecessary(Meter.Id id, Quantiles quantiles) {
        if (quantiles != null) {
            for (Double q : quantiles.monitored()) {
                this.gauge(id.getName(), Tags.concat(id.getTags(), "quantile", Double.isNaN(q) ? "NaN" : Double.toString(q)), q, quantiles::get);
            }
        }
    }

    private Histogram<?> registerHistogramCounterIfNecessary(Meter.Id id, Histogram.Builder<?> histogramBuilder) {
        if (histogramBuilder != null) {
            Histogram<?> hist = histogramBuilder.create(Histogram.Summation.Normal);
            for (Bucket<?> bucket : hist.getBuckets()) {
                this.more().counter(this.createId(id.getName(), Tags.concat(id.getTags(), "bucket", bucket.getTagString()), null), bucket, Bucket::getValue);
            }
            return hist;
        }
        return null;
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        SimpleLongTaskTimer ltt = new SimpleLongTaskTimer(id, this.clock);
        this.registry.register(this.hierarchicalName(id) + ".active", (Metric)((com.codahale.metrics.Gauge)ltt::activeTasks));
        this.registry.register(this.hierarchicalName(id) + ".duration", (Metric)((com.codahale.metrics.Gauge)() -> ltt.duration(TimeUnit.NANOSECONDS)));
        return ltt;
    }

    @Override
    protected void newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        measurements.forEach(ms -> {
            com.codahale.metrics.Gauge cfr_ignored_0 = (com.codahale.metrics.Gauge)this.registry.register(this.hierarchicalName(id), (Metric)((com.codahale.metrics.Gauge)ms::getValue));
        });
    }

    @Override
    protected <T> Gauge newTimeGauge(Meter.Id id, T obj, TimeUnit fUnit, ToDoubleFunction<T> f) {
        id.setBaseUnit("nanoseconds");
        return this.newGauge(id, obj, obj2 -> TimeUtils.convert(f.applyAsDouble(obj2), fUnit, TimeUnit.NANOSECONDS));
    }

    private String hierarchicalName(Meter.Id id) {
        return this.nameMapper.toHierarchicalName(id, this.config().namingConvention());
    }
}

