/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeter;
import io.micrometer.core.instrument.noop.NoopLongTaskTimer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CompositeLongTaskTimer
extends AbstractMeter
implements LongTaskTimer,
CompositeMeter {
    private final Map<MeterRegistry, LongTaskTimer> timers = Collections.synchronizedMap(new LinkedHashMap());

    CompositeLongTaskTimer(Meter.Id id) {
        super(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long start() {
        Map<MeterRegistry, LongTaskTimer> map = this.timers;
        synchronized (map) {
            return this.timers.values().stream().map(LongTaskTimer::start).reduce((t1, t2) -> t2).orElse(NoopLongTaskTimer.INSTANCE.start());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long stop(long task) {
        Map<MeterRegistry, LongTaskTimer> map = this.timers;
        synchronized (map) {
            return this.timers.values().stream().map(ltt -> ltt.stop(task)).reduce((t1, t2) -> t2 == -1L ? t1 : t2).orElse(NoopLongTaskTimer.INSTANCE.stop(task));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double duration(long task, TimeUnit unit) {
        Map<MeterRegistry, LongTaskTimer> map = this.timers;
        synchronized (map) {
            return this.timers.values().stream().map(ltt -> ltt.duration(task, unit)).reduce((t1, t2) -> t2 == -1.0 ? t1 : t2).orElse(NoopLongTaskTimer.INSTANCE.duration(task, unit));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double duration(TimeUnit unit) {
        Map<MeterRegistry, LongTaskTimer> map = this.timers;
        synchronized (map) {
            return this.timers.values().stream().map(ltt -> ltt.duration(unit)).reduce((t1, t2) -> t2).orElse(NoopLongTaskTimer.INSTANCE.duration(unit));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int activeTasks() {
        Map<MeterRegistry, LongTaskTimer> map = this.timers;
        synchronized (map) {
            return this.timers.values().stream().map(LongTaskTimer::activeTasks).reduce((t1, t2) -> t2).orElse(NoopLongTaskTimer.INSTANCE.activeTasks());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(MeterRegistry registry) {
        Map<MeterRegistry, LongTaskTimer> map = this.timers;
        synchronized (map) {
            this.timers.put(registry, registry.more().longTaskTimer(this.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(MeterRegistry registry) {
        Map<MeterRegistry, LongTaskTimer> map = this.timers;
        synchronized (map) {
            this.timers.remove(registry);
        }
    }
}

