/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.Collections;

public class ProcessorMetrics
implements MeterBinder {
    private final Iterable<Tag> tags;

    public ProcessorMetrics() {
        this(Collections.emptyList());
    }

    public ProcessorMetrics(Iterable<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Runtime runtime = Runtime.getRuntime();
        registry.gauge(registry.createId("cpu", this.tags, "The number of processors available to the Java virtual machine"), runtime, Runtime::availableProcessors);
        OperatingSystemMXBean operatingSystemBean = ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystemBean != null && operatingSystemBean.getSystemLoadAverage() >= 0.0) {
            registry.gauge(registry.createId("cpu.load.average", this.tags, "The sum of the number of runnable entities queued to available processors and the number of runnable entities running on the available processors averaged over a period of time"), operatingSystemBean, OperatingSystemMXBean::getSystemLoadAverage);
        }
    }
}

