/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Meter;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public interface NamingConvention {
    public static final NamingConvention identity = (name, type, baseUnit) -> name;
    public static final NamingConvention snakeCase = new NamingConvention(){

        @Override
        public String name(String name, Meter.Type type, String baseUnit) {
            return this.toSnakeCase(name);
        }

        @Override
        public String tagKey(String key) {
            return this.toSnakeCase(key);
        }

        private String toSnakeCase(String value) {
            return Arrays.stream(value.split("\\.")).filter(Objects::nonNull).collect(Collectors.joining("_"));
        }
    };
    public static final NamingConvention camelCase = new NamingConvention(){

        @Override
        public String name(String name, Meter.Type type, String baseUnit) {
            return this.toCamelCase(name);
        }

        @Override
        public String tagKey(String key) {
            return this.toCamelCase(key);
        }

        private String toCamelCase(String value) {
            String[] parts = value.split("\\.");
            StringBuilder conventionName = new StringBuilder();
            for (int i = 0; i < parts.length; ++i) {
                String str = parts[i];
                if (str == null || str.length() == 0) continue;
                if (i == 0) {
                    conventionName.append(str.toLowerCase());
                    continue;
                }
                char firstChar = str.charAt(0);
                if (Character.isTitleCase(firstChar)) {
                    conventionName.append(str);
                    continue;
                }
                conventionName.append(String.valueOf(Character.toTitleCase(firstChar))).append(str.substring(1));
            }
            return conventionName.toString();
        }
    };

    default public String name(String name, Meter.Type type) {
        return this.name(name, type, null);
    }

    public String name(String var1, Meter.Type var2, String var3);

    default public String tagKey(String key) {
        return key;
    }

    default public String tagValue(String value) {
        return value;
    }
}

