/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;

public class URLClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public boolean handle(ClassLoader classLoader, ClasspathFinder classpathFinder, LogNode log) {
        URL[] urls;
        boolean handled = false;
        List<ClassLoader> classLoaders = Arrays.asList(classLoader);
        if (classLoader instanceof URLClassLoader && (urls = ((URLClassLoader)classLoader).getURLs()) != null) {
            for (URL url : urls) {
                if (url == null) continue;
                handled = classpathFinder.addClasspathElement(url.toString(), classLoaders, log);
            }
        }
        return handled;
    }
}

