/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.ConnectorFactory;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.maven.AbstractFabric8Mojo;
import io.fabric8.maven.helm.Chart;
import io.fabric8.utils.Files;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.util.FS;

@Mojo(name="helm", defaultPhase=LifecyclePhase.PACKAGE)
public class HelmMojo
extends AbstractFabric8Mojo {
    public static final String HELM_YAML_EXTENSION = ".yaml";
    public static final String PROPERTY_HELM_GIT_URL = "fabric8.helm.gitUrl";
    public static final String PROPERTY_HELM_CHART_NAME = "fabric8.helm.chart";
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="fabric8.helm.gitUrl", defaultValue="git@github.com:fabric8io/charts.git")
    private String helmGitUrl;
    @Parameter(property="fabric8.yaml.target", defaultValue="${basedir}/target/classes/kubernetes.yml")
    private File kubernetesYaml;
    @Parameter(property="fabric8.helm.cloneDir")
    private File helmCloneDir;
    @Parameter(property="fabric8.helm.privateKeyPath")
    private String privateKeyPath;
    @Parameter(property="fabric8.helm.privateKeyPassphrase")
    private String privateKeyPassphrase;
    @Parameter(property="fabric8.helm.chart", defaultValue="${project.artifactId}")
    private String chartName;
    @Parameter(property="fabric8.helm.gitRemote", defaultValue="origin")
    protected String remoteRepoName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File yaml = this.getKubernetesYaml();
        if (Files.isFile((File)yaml)) {
            this.getLog().info((CharSequence)("Creating Helm Chart for kubernetes yaml file: " + yaml));
            File outputDir = this.getOutputDir();
            if (outputDir != null) {
                File basedir;
                File manifestsDir = new File(outputDir, "manifests");
                if (Files.isDirectory((File)manifestsDir)) {
                    Files.recursiveDelete((File)manifestsDir);
                }
                manifestsDir.mkdirs();
                File outputYamlFile = new File(manifestsDir, this.chartName + HELM_YAML_EXTENSION);
                try {
                    Files.copy((File)yaml, (File)outputYamlFile);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to copy file " + yaml + " to chart manifest file: " + outputYamlFile + ". Reason: " + e, (Exception)e);
                }
                File outputChartFile = new File(outputDir, "Chart.yaml");
                Chart chart = this.createChart();
                try {
                    KubernetesHelper.saveYaml((Object)chart, (File)outputChartFile);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to save chart " + outputChartFile + ". Reason: " + e, (Exception)e);
                }
                MavenProject project = this.getProject();
                if (project != null && (basedir = project.getBasedir()) != null) {
                    String outputReadMeFileName = "README.md";
                    try {
                        HelmMojo.copyReadMe(basedir, outputDir, outputReadMeFileName);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Failed to save " + outputReadMeFileName + ". Reason: " + e, (Exception)e);
                    }
                }
                this.getLog().info((CharSequence)("Generated Helm Chart " + this.chartName + " at " + outputDir));
            }
        }
    }

    public String getHelmGitUrl() {
        return this.helmGitUrl;
    }

    protected Chart createChart() {
        Chart answer = new Chart();
        answer.setName(this.chartName);
        MavenProject project = this.getProject();
        if (project != null) {
            answer.setVersion(project.getVersion());
            answer.setDescription(project.getDescription());
            answer.setHome(project.getUrl());
            List developers = project.getDevelopers();
            if (developers != null) {
                ArrayList<String> maintainers = new ArrayList<String>();
                for (Developer developer : developers) {
                    String email = developer.getEmail();
                    String name = developer.getName();
                    String text = Strings.defaultIfEmpty((String)name, (String)"");
                    if (Strings.isNotBlank((String)email)) {
                        text = Strings.isNotBlank((String)text) ? text + " <" + email + ">" : email;
                    }
                    if (!Strings.isNotBlank((String)text)) continue;
                    maintainers.add(text);
                }
                answer.setMaintainers(maintainers);
            }
        }
        return answer;
    }

    protected File getOutputDir() throws MojoExecutionException {
        File helmRepoDir = this.getHelmRepoFolder();
        if (helmRepoDir == null) {
            return null;
        }
        if (Strings.isNullOrBlank((String)this.helmGitUrl)) {
            this.getLog().warn((CharSequence)"No git url so cannot clone a Helm repository. Please specify the `fabric8.helm.gitUrl` property");
        } else {
            this.cloneGitRepository(helmRepoDir, this.helmGitUrl);
        }
        if (Strings.isNullOrBlank((String)this.chartName)) {
            throw new MojoExecutionException("No Chart name defined! Please specify the `fabric8.helm.chart` property");
        }
        return new File(helmRepoDir, this.chartName);
    }

    protected File getHelmRepoFolder() {
        File rootProjectFolder;
        if (this.helmCloneDir == null && (rootProjectFolder = this.getRootProjectFolder()) != null) {
            this.helmCloneDir = new File(rootProjectFolder, "target/helm-repo");
        }
        return this.helmCloneDir;
    }

    protected void cloneGitRepository(File outputFolder, String gitUrl) {
        File gitFolder = new File(outputFolder, ".git");
        if (!Files.isDirectory((File)gitFolder)) {
            CloneCommand command = Git.cloneRepository();
            command = command.setURI(gitUrl).setDirectory(outputFolder).setRemote(this.remoteRepoName);
            this.setupCredentials(command);
            try {
                Git git = command.call();
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to clone chart repo " + gitUrl + " due: ", e);
            }
        }
    }

    private void setupCredentials(CloneCommand command) {
        command.setTransportConfigCallback(new TransportConfigCallback(){

            public void configure(Transport transport) {
                SshTransport sshTransport = (SshTransport)transport;
                sshTransport.setSshSessionFactory((SshSessionFactory)new JschConfigSessionFactory(){

                    protected void configure(OpenSshConfig.Host host, Session session) {
                    }

                    protected JSch createDefaultJSch(FS fs) throws JSchException {
                        JSch jsch = super.createDefaultJSch(fs);
                        if (!Strings.isNullOrBlank((String)HelmMojo.this.privateKeyPath)) {
                            HelmMojo.this.getLog().debug((CharSequence)("helm: Using SSH private key from " + HelmMojo.this.privateKeyPath));
                            jsch.removeAllIdentity();
                            if (!Strings.isNullOrBlank((String)HelmMojo.this.privateKeyPassphrase)) {
                                jsch.addIdentity(HelmMojo.this.privateKeyPath, HelmMojo.this.privateKeyPassphrase);
                            } else {
                                jsch.addIdentity(HelmMojo.this.privateKeyPath);
                            }
                        } else {
                            try {
                                ConnectorFactory cf = ConnectorFactory.getDefault();
                                Connector con = cf.createConnector();
                                RemoteIdentityRepository irepo = new RemoteIdentityRepository(con);
                                jsch.setIdentityRepository((IdentityRepository)irepo);
                                HelmMojo.this.getLog().debug((CharSequence)"helm: Using ssh-agent");
                            }
                            catch (AgentProxyException e) {
                                HelmMojo.this.getLog().debug((CharSequence)"helm: No ssh-agent available");
                            }
                        }
                        return jsch;
                    }
                });
            }
        });
    }

    public File getKubernetesYaml() {
        return this.kubernetesYaml;
    }
}

