/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.devops.ProjectConfig;
import io.fabric8.devops.ProjectConfigs;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import java.io.File;
import java.util.LinkedHashMap;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractNamespacedMojo
extends AbstractMojo {
    @Parameter(property="fabric8.namespace")
    private String namespace;
    @Parameter(property="fabric8.environment")
    private String environment;
    @Parameter(property="fabric8.domain")
    protected String routeDomain;
    @Parameter(property="fabric8.apply.failOnError", defaultValue="true")
    protected boolean failOnError;
    @Parameter(property="fabric8.recreate", defaultValue="false")
    protected boolean recreate;
    private KubernetesClient kubernetes;

    public KubernetesClient getKubernetes() {
        return new DefaultKubernetesClient();
    }

    protected Controller createController() {
        Controller controller = new Controller(this.getKubernetes());
        controller.setThrowExceptionOnError(this.failOnError);
        controller.setRecreateMode(this.recreate);
        this.getLog().debug((CharSequence)("Using recreate mode: " + this.recreate));
        return controller;
    }

    protected synchronized String getNamespace() {
        if (Strings.isNullOrBlank((String)this.namespace) && Strings.isNotBlank((String)this.environment)) {
            this.namespace = this.getNamespaceForEnvironment(this.environment);
        }
        if (Strings.isNullOrBlank((String)this.namespace)) {
            this.namespace = KubernetesHelper.defaultNamespace();
        }
        return this.namespace;
    }

    protected String getNamespaceForEnvironment(String environment) throws IllegalStateException {
        String envVarName;
        LinkedHashMap environments;
        String namespace = null;
        ProjectConfig projectConfig = this.findProjectConfig();
        if (projectConfig != null && (environments = projectConfig.getEnvironments()) != null) {
            namespace = (String)environments.get(environment);
        }
        if (Strings.isNullOrBlank(namespace) && Strings.isNullOrBlank((String)(namespace = Systems.getEnvVarOrSystemProperty((String)(envVarName = environment.toUpperCase() + "_NAMESPACE"))))) {
            throw new IllegalStateException("Could not find namespace for environment `" + environment + "` by looking for a fabric8.yml file and at environment variable $" + envVarName);
        }
        if (Strings.isNotBlank(namespace)) {
            this.getLog().info((CharSequence)("Mapping environment `" + environment + "` to namespace `" + namespace + "`"));
        }
        return namespace;
    }

    protected ProjectConfig findProjectConfig() {
        MavenProject project;
        MavenProject rootProject = this.getRootProject();
        File basedir = null;
        if (rootProject != null) {
            basedir = rootProject.getBasedir();
        }
        if (basedir == null && (project = this.getProject()) != null) {
            basedir = project.getBasedir();
        }
        if (basedir == null) {
            basedir = new File(System.getProperty("basedir", "."));
        }
        return ProjectConfigs.loadFromFolder((File)basedir);
    }

    public String getRouteDomain() {
        return this.routeDomain;
    }

    public void setRouteDomain(String routeDomain) {
        this.routeDomain = routeDomain;
    }

    public boolean isRecreate() {
        return this.recreate;
    }

    public void setRecreate(boolean recreate) {
        this.recreate = recreate;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public MavenProject getProject() {
        return null;
    }

    protected File getRootProjectFolder() {
        File answer = null;
        for (MavenProject project = this.getProject(); project != null; project = project.getParent()) {
            File basedir = project.getBasedir();
            if (basedir == null) continue;
            answer = basedir;
        }
        return answer;
    }

    protected MavenProject getRootProject() {
        MavenProject parent;
        MavenProject project = this.getProject();
        while (project != null && (parent = project.getParent()) != null) {
            project = parent;
        }
        return project;
    }
}

