/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access.hc.http;

import io.fabric8.maven.docker.access.KeyStoreUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpClientBuilder {
    private String certPath = null;
    private int maxConnections = 100;

    public HttpClientBuilder certPath(String certPath) {
        this.certPath = certPath;
        return this;
    }

    public HttpClientBuilder maxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public CloseableHttpClient build() throws IOException {
        org.apache.http.impl.client.HttpClientBuilder builder = HttpClients.custom();
        HttpClientConnectionManager manager = HttpClientBuilder.getConnectionFactory(this.certPath, this.maxConnections);
        builder.setConnectionManager(manager);
        return builder.build();
    }

    private static HttpClientConnectionManager getConnectionFactory(String certPath, int maxConnections) throws IOException {
        PoolingHttpClientConnectionManager ret = certPath != null ? new PoolingHttpClientConnectionManager(HttpClientBuilder.getSslFactoryRegistry(certPath)) : new PoolingHttpClientConnectionManager();
        ret.setDefaultMaxPerRoute(maxConnections);
        return ret;
    }

    private static Registry<ConnectionSocketFactory> getSslFactoryRegistry(String certPath) throws IOException {
        try {
            KeyStore keyStore = KeyStoreUtil.createDockerKeyStore(certPath);
            SSLContext sslContext = SSLContexts.custom().useTLS().loadKeyMaterial(keyStore, "docker".toCharArray()).loadTrustMaterial(keyStore).build();
            String tlsVerify = System.getenv("DOCKER_TLS_VERIFY");
            SSLConnectionSocketFactory sslsf = tlsVerify != null && !tlsVerify.equals("0") && !tlsVerify.equals("false") ? new SSLConnectionSocketFactory(sslContext) : new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return RegistryBuilder.create().register("https", (Object)sslsf).build();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }
}

