/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access;

import io.fabric8.maven.docker.model.Container;
import io.fabric8.maven.docker.util.EnvUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortMapping {
    private static final Pattern PROTOCOL_SPLIT_PATTERN = Pattern.compile("(.*?)(?:/(tcp|udp))?$");
    private final Map<String, String> bindToHostMap = new HashMap<String, String>();
    private final Map<String, Integer> containerPortToHostPort = new HashMap<String, Integer>();
    private final Properties dynamicProperties = new Properties();
    private final Map<String, String> hostIpVariableMap = new HashMap<String, String>();
    private final Map<String, Integer> hostPortVariableMap = new HashMap<String, Integer>();
    private final Properties projProperties;
    private final Map<String, String> specToHostIpVariableMap = new HashMap<String, String>();
    private final Map<String, String> specToHostPortVariableMap = new HashMap<String, String>();

    public PortMapping(List<String> portMappings, Properties projProperties) {
        this.projProperties = projProperties;
        for (String portMapping : portMappings) {
            this.parsePortMapping(portMapping);
        }
    }

    public boolean containsDynamicHostIps() {
        return !this.specToHostIpVariableMap.isEmpty();
    }

    public boolean containsDynamicPorts() {
        return !this.specToHostPortVariableMap.isEmpty();
    }

    public Set<String> getContainerPorts() {
        return this.containerPortToHostPort.keySet();
    }

    public Map<String, Integer> getContainerPortToHostPortMap() {
        return this.containerPortToHostPort;
    }

    public void updateVariablesWithDynamicPorts(Map<String, Container.PortBinding> dockerObtainedDynamicPorts) {
        for (Map.Entry<String, Container.PortBinding> entry : dockerObtainedDynamicPorts.entrySet()) {
            String variable = entry.getKey();
            Container.PortBinding portBinding = entry.getValue();
            if (portBinding == null) continue;
            this.update(this.hostPortVariableMap, this.specToHostPortVariableMap.get(variable), portBinding.getHostPort());
            String hostIp = portBinding.getHostIp();
            if ("0.0.0.0".equals(hostIp)) {
                hostIp = this.projProperties.getProperty("docker.host.address");
            }
            this.update(this.hostIpVariableMap, this.specToHostIpVariableMap.get(variable), hostIp);
        }
        this.updateDynamicProperties(this.hostPortVariableMap);
        this.updateDynamicProperties(this.hostIpVariableMap);
    }

    Map<String, String> getBindToHostMap() {
        return this.bindToHostMap;
    }

    Map<String, String> getHostIpVariableMap() {
        return this.hostIpVariableMap;
    }

    Map<String, Integer> getHostPortVariableMap() {
        return this.hostPortVariableMap;
    }

    Map<String, Integer> getPortsMap() {
        return this.containerPortToHostPort;
    }

    private IllegalArgumentException createInvalidMappingError(String mapping, NumberFormatException exp) {
        return new IllegalArgumentException("\nInvalid port mapping '" + mapping + "'\n" + "Required format: '<+bindTo>:<hostPort>:<mappedPort>(/tcp|udp)'\n" + "See: https://github.com/fabric8io/docker-maven-plugin/blob/master/doc/manual.md#port-mapping");
    }

    private void createMapping(String[] parts, String protocol) {
        if (parts.length == 3) {
            this.mapBindToAndHostPortSpec(parts[0], parts[1], this.createPortSpec(parts[2], protocol));
        } else {
            this.mapHostPortToSpec(parts[0], this.createPortSpec(parts[1], protocol));
        }
    }

    private String createPortSpec(String port, String protocol) throws NumberFormatException {
        return Integer.parseInt(port) + "/" + protocol;
    }

    private Integer getAsIntOrNull(String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException exp) {
            return null;
        }
    }

    private Integer getPortFromVariableOrSystemProperty(String var) {
        String sysProp = System.getProperty(var);
        if (sysProp != null) {
            return this.getAsIntOrNull(sysProp);
        }
        if (this.projProperties.containsKey(var)) {
            return this.getAsIntOrNull(this.projProperties.getProperty(var));
        }
        return null;
    }

    private String extractPortPropertyName(String name) {
        String mavenPropName = EnvUtil.extractMavenPropertyName(name);
        return mavenPropName != null ? mavenPropName : name;
    }

    private void mapBindToAndHostPortSpec(String bindTo, String hPort, String portSpec) {
        this.mapHostPortToSpec(hPort, portSpec);
        String hostPropName = this.extractHostPropertyName(bindTo);
        if (hostPropName != null) {
            String host = this.projProperties.getProperty(hostPropName);
            if (host != null) {
                this.bindToHostMap.put(portSpec, this.resolveHostname(host));
            }
            this.specToHostIpVariableMap.put(portSpec, hostPropName);
        } else {
            this.bindToHostMap.put(portSpec, this.resolveHostname(bindTo));
        }
    }

    private String extractHostPropertyName(String name) {
        if (name.startsWith("+")) {
            return name.substring(1);
        }
        return EnvUtil.extractMavenPropertyName(name);
    }

    private void mapHostPortToSpec(String hPort, String portSpec) {
        Integer hostPort;
        try {
            hostPort = Integer.parseInt(hPort);
        }
        catch (NumberFormatException exp) {
            String portPropertyName = this.extractPortPropertyName(hPort);
            hostPort = this.getPortFromVariableOrSystemProperty(portPropertyName);
            if (hostPort != null) {
                this.hostPortVariableMap.put(portPropertyName, hostPort);
            }
            this.specToHostPortVariableMap.put(portSpec, portPropertyName);
        }
        this.containerPortToHostPort.put(portSpec, hostPort);
    }

    private void parsePortMapping(String input) throws IllegalArgumentException {
        try {
            Matcher matcher = PROTOCOL_SPLIT_PATTERN.matcher(input);
            if (input.indexOf(58) == -1 || !matcher.matches()) {
                throw this.createInvalidMappingError(input, null);
            }
            String mapping = matcher.group(1);
            String protocol = matcher.group(2);
            if (protocol == null) {
                protocol = "tcp";
            }
            this.createMapping(mapping.split(":", 3), protocol);
        }
        catch (NumberFormatException exp) {
            throw this.createInvalidMappingError(input, exp);
        }
    }

    private String resolveHostname(String bindToHost) {
        try {
            return InetAddress.getByName(bindToHost).getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Host '" + bindToHost + "' to bind to cannot be resolved");
        }
    }

    private <T> void update(Map<String, T> map, String key, T value) {
        if (key != null) {
            map.put(key, value);
        }
    }

    private void updateDynamicProperties(Map<String, ?> dynamicPorts) {
        for (Map.Entry<String, ?> entry : dynamicPorts.entrySet()) {
            String var = entry.getKey();
            String val = entry.getValue().toString();
            this.projProperties.setProperty(var, val);
            this.dynamicProperties.setProperty(var, val);
        }
    }

    public static class PropertyWriteHelper {
        private final Properties globalExport;
        private final String globalFile;
        private final Map<String, Properties> toExport;

        public PropertyWriteHelper(String globalFile) {
            this.globalFile = globalFile;
            this.toExport = new HashMap<String, Properties>();
            this.globalExport = new Properties();
        }

        public void add(PortMapping portMapping, String portPropertyFile) {
            if (portPropertyFile != null) {
                this.toExport.put(portPropertyFile, portMapping.dynamicProperties);
            } else if (this.globalFile != null) {
                this.globalExport.putAll((Map<?, ?>)portMapping.dynamicProperties);
            }
        }

        public void write() throws IOException {
            for (Map.Entry<String, Properties> entry : this.toExport.entrySet()) {
                Properties props = entry.getValue();
                this.writeProperties(props, entry.getKey());
                this.globalExport.putAll((Map<?, ?>)props);
            }
            if (this.globalFile != null && !this.globalExport.isEmpty()) {
                this.writeProperties(this.globalExport, this.globalFile);
            }
        }

        private void writeProperties(Properties props, String file) throws IOException {
            File propFile = new File(file);
            try (FileOutputStream os = new FileOutputStream(propFile);){
                props.store(os, "Docker ports");
            }
            catch (IOException e) {
                throw new IOException("Cannot write properties to " + file + ": " + e, e);
            }
        }
    }
}

