/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.http;

import com.gexin.rp.sdk.base.IAliasResult;
import com.gexin.rp.sdk.base.IBatch;
import com.gexin.rp.sdk.base.IGtAPN;
import com.gexin.rp.sdk.base.IGtAlias;
import com.gexin.rp.sdk.base.IIGtPush;
import com.gexin.rp.sdk.base.IIGtQuery;
import com.gexin.rp.sdk.base.IListProvider;
import com.gexin.rp.sdk.base.IPushEventListener;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.IQueryResult;
import com.gexin.rp.sdk.base.impl.AppMessage;
import com.gexin.rp.sdk.base.impl.ListMessage;
import com.gexin.rp.sdk.base.impl.SingleMessage;
import com.gexin.rp.sdk.base.impl.Target;
import com.gexin.rp.sdk.exceptions.PushAppException;
import com.gexin.rp.sdk.exceptions.PushSingleException;
import com.gexin.rp.sdk.http.GtPush;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class IGtPush
implements IIGtPush,
IIGtQuery,
IGtAPN,
IGtAlias {
    private static final ConcurrentHashMap<String, GtPush> pushMap = new ConcurrentHashMap();
    private GtPush push;

    public IGtPush(String appKey, String masterSecret) {
        this(null, appKey, masterSecret, null);
    }

    public IGtPush(String host, String appKey, String masterSecret) {
        this(host, appKey, masterSecret, null);
    }

    @Deprecated
    public IGtPush(String host, String appKey, String masterSecret, Boolean usePool) {
        usePool = false;
        String key = host + "|" + appKey + "|" + (usePool == null ? false : usePool);
        if (!pushMap.containsKey(key)) {
            pushMap.putIfAbsent(key, new GtPush(host, appKey, masterSecret));
        }
        this.push = pushMap.get(key);
    }

    public boolean connect() throws IOException {
        return this.push.connect();
    }

    public void close() throws IOException {
        this.push.close();
    }

    public IPushResult pushMessageToSingle(SingleMessage message, Target target) throws PushSingleException {
        return this.push.pushMessageToSingle(message, target);
    }

    public IPushResult pushMessageToSingle(SingleMessage message, Target target, String requestId) throws PushSingleException {
        return this.push.pushMessageToSingle(message, target, requestId);
    }

    public void pushMessageToList(ListMessage message, IListProvider listProvider, IPushEventListener listener) {
        this.push.pushMessageToList(message, listProvider, listener);
    }

    public String getContentId(ListMessage message) {
        return this.push.getContentId(message);
    }

    public String getContentId(ListMessage message, String taskGroupName) {
        return this.push.getContentId(message, taskGroupName);
    }

    public boolean cancelContentId(String contentId) {
        return this.push.cancelContentId(contentId);
    }

    public IPushResult addCidListToBlk(String appId, List<String> cidList) {
        return this.push.addCidListToBlk(appId, cidList);
    }

    public IPushResult restoreCidListFromBlk(String appId, List<String> cidList) {
        return this.push.restoreCidListFromBlk(appId, cidList);
    }

    public IPushResult pushMessageToList(String contentId, List<Target> targetList) {
        return this.push.pushMessageToList(contentId, targetList);
    }

    public IPushResult pushMessageToApp(AppMessage message) throws PushAppException {
        return this.push.pushMessageToApp(message);
    }

    public IPushResult pushMessageToApp(AppMessage message, String taskGroupName) throws PushAppException {
        return this.push.pushMessageToApp(message, taskGroupName);
    }

    public boolean stop(String contentId) {
        return this.push.stop(contentId);
    }

    public IQueryResult getClientIdStatus(String appId, String clientId) {
        return this.push.getClientIdStatus(appId, clientId);
    }

    public IQueryResult setClientTag(String appId, String clientId, List<String> tags) {
        return this.push.setClientTag(appId, clientId, tags);
    }

    public IBatch getBatch() {
        return this.push.getBatch();
    }

    public IPushResult pushAPNMessageToSingle(String appId, String deviceToken, SingleMessage message) {
        return this.push.pushAPNMessageToSingle(appId, deviceToken, message);
    }

    public IPushResult pushAPNMessageToList(String appId, String contentId, List<String> deviceTokenList) {
        return this.push.pushAPNMessageToList(appId, contentId, deviceTokenList);
    }

    public String getAPNContentId(String appId, ListMessage message) {
        return this.push.getAPNContentId(appId, message);
    }

    public IAliasResult bindAlias(String appId, String alias, String clientId) {
        return this.push.bindAlias(appId, alias, clientId);
    }

    public IAliasResult bindAlias(String appId, List<Target> targetList) {
        return this.push.bindAlias(appId, targetList);
    }

    public IAliasResult queryClientId(String appId, String alias) {
        return this.push.queryClientId(appId, alias);
    }

    public IAliasResult queryAlias(String appId, String clientId) {
        return this.push.queryAlias(appId, clientId);
    }

    public IAliasResult unBindAlias(String appId, String alias, String clientId) {
        return this.push.unBindAlias(appId, alias, clientId);
    }

    public IAliasResult unBindAliasAll(String appId, String alias) {
        return this.push.unBindAliasAll(appId, alias);
    }

    public IPushResult getPushResult(String taskId) {
        return this.push.getPushResult(taskId);
    }

    public IQueryResult getPushResultByGroupName(String appId, String groupName) {
        return this.push.getPushResultByGroupName(appId, groupName);
    }

    public IQueryResult getLast24HoursOnlineUserStatistics(String appId) {
        return this.push.getLast24HoursOnlineUserStatistics(appId);
    }

    public IPushResult getUserTags(String appId, String clientId) {
        return this.push.getUserTags(appId, clientId);
    }

    public IQueryResult queryAppPushDataByDate(String appId, String date) {
        return this.push.queryAppPushDataByDate(appId, date);
    }

    public IQueryResult queryAppUserDataByDate(String appId, String date) {
        return this.push.queryAppUserDataByDate(appId, date);
    }
}

