/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.heapoff.structs.structtypes;

import de.ruedigermoeller.heapoff.structs.FSTStruct;
import de.ruedigermoeller.heapoff.structs.NoAssist;

public class StructString
extends FSTStruct
implements Comparable {
    protected int len = 0;
    protected char[] chars;

    public StructString(int size) {
        this.chars = new char[size];
        this.len = 0;
    }

    public StructString(String init, int size) {
        this.chars = new char[size];
        this.len = 0;
        this.setString(init);
    }

    public StructString(String s) {
        this.chars = s.toCharArray();
        this.len = s.length();
    }

    public void setString(String s) {
        if (s == null) {
            this.setLen(0);
            return;
        }
        if (s.length() > this.charsLen()) {
            throw new RuntimeException("String length exceeds buffer size. String len " + s.length() + " charsLen:" + this.charsLen());
        }
        for (int i = 0; i < s.length(); ++i) {
            this.chars(i, s.charAt(i));
        }
        this.len = s.length();
    }

    public int getLen() {
        return this.len;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public void chars(int i, char val) {
        this.chars[i] = val;
    }

    public char chars(int i) {
        return this.chars[i];
    }

    public int compareTo(StructString str) {
        int l1 = this.len;
        int l2 = str.getLen();
        int max = Math.min(l1, l2);
        for (int i = 0; i < max; ++i) {
            char c2;
            char c1 = this.chars(i);
            if (c1 == (c2 = str.chars(i))) continue;
            return c1 - c2;
        }
        return l1 - l2;
    }

    public int compareToString(String str) {
        int l1 = this.len;
        int l2 = str.length();
        int max = Math.min(l1, l2);
        for (int i = 0; i < max; ++i) {
            char c2;
            char c1 = this.chars(i);
            if (c1 == (c2 = str.charAt(i))) continue;
            return c1 - c2;
        }
        return l1 - l2;
    }

    public int charsLen() {
        return this.chars.length;
    }

    public String toString() {
        char[] ch = new char[this.len];
        for (int i = 0; i < this.len; ++i) {
            ch[i] = this.chars(i);
        }
        return new String(ch);
    }

    @Override
    public int hashCode() {
        if (this.len > 6) {
            return this.chars(0) + this.chars(3) << 16 + this.chars(this.len - 1) << 32 + this.chars(this.len - 3) << 48;
        }
        if (this.len > 1) {
            return this.chars(0) + this.chars(1) << 16 + this.chars(this.len - 1) << 32 + this.chars(this.len - 2) << 48;
        }
        if (this.len > 0) {
            return this.chars(0);
        }
        return 97979797;
    }

    @Override
    @NoAssist
    public boolean equals(Object o) {
        if (o instanceof StructString) {
            StructString ss = (StructString)o;
            if (ss.getLen() != this.getLen()) {
                return false;
            }
            for (int i = 0; i < ss.getLen(); ++i) {
                if (ss.chars(i) == this.chars(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @NoAssist
    public int compareTo(Object o) {
        if (o instanceof StructString) {
            return this.compareTo((StructString)o);
        }
        return -1;
    }

    @Override
    @NoAssist
    public Object getFieldValues() {
        return this.toString();
    }
}

