/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.notify;

import de.codecentric.boot.admin.event.ClientApplicationEvent;
import de.codecentric.boot.admin.event.ClientApplicationStatusChangedEvent;
import de.codecentric.boot.admin.notify.AbstractStatusChangeNotifier;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.web.client.RestTemplate;

public class HipchatNotifier
extends AbstractStatusChangeNotifier {
    private static final String DEFAULT_DESCRIPTION = "<strong>#{application.name}</strong>/#{application.id} is <strong>#{to.status}</strong>";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private RestTemplate restTemplate = new RestTemplate();
    private URI url;
    private String authToken;
    private String roomId;
    private boolean notify = false;
    private Expression description = this.parser.parseExpression("<strong>#{application.name}</strong>/#{application.id} is <strong>#{to.status}</strong>", ParserContext.TEMPLATE_EXPRESSION);

    @Override
    protected void doNotify(ClientApplicationEvent event) {
        this.restTemplate.postForEntity(this.buildUrl(), this.createHipChatNotification(event), Void.class, new Object[0]);
    }

    protected String buildUrl() {
        return String.format("%s/room/%s/notification?auth_token=%s", this.url.toString(), this.roomId, this.authToken);
    }

    protected Map<String, Object> createHipChatNotification(ClientApplicationEvent event) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("color", this.getColor(event));
        result.put("message", this.getMessage(event));
        result.put("notify", this.getNotify());
        result.put("message_format", "html");
        return result;
    }

    protected boolean getNotify() {
        return this.notify;
    }

    protected String getMessage(ClientApplicationEvent event) {
        return (String)this.description.getValue((Object)event, String.class);
    }

    protected String getColor(ClientApplicationEvent event) {
        if (event instanceof ClientApplicationStatusChangedEvent) {
            return "UP".equals(((ClientApplicationStatusChangedEvent)event).getTo().getStatus()) ? "green" : "red";
        }
        return "gray";
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
    }

    public void setDescription(String description) {
        this.description = this.parser.parseExpression(description, ParserContext.TEMPLATE_EXPRESSION);
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

