/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.notify;

import de.codecentric.boot.admin.event.ClientApplicationEvent;
import de.codecentric.boot.admin.notify.Notifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventNotifier
implements Notifier {
    private boolean enabled = true;

    @Override
    public void notify(ClientApplicationEvent event) {
        if (this.enabled && this.shouldNotify(event)) {
            try {
                this.doNotify(event);
            }
            catch (Exception ex) {
                this.getLogger().error("Couldn't notify for event {} ", (Object)event, (Object)ex);
            }
        }
    }

    protected abstract boolean shouldNotify(ClientApplicationEvent var1);

    protected abstract void doNotify(ClientApplicationEvent var1) throws Exception;

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

