/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.maven.plugin;

public class JavaDetectionTools {
    public static final boolean IS_JAVA_8 = JavaDetectionTools.isJavaVersion(8);
    public static final boolean IS_JAVA_9 = !IS_JAVA_8 && JavaDetectionTools.isJavaVersion(9) || JavaDetectionTools.isJavaVersion(9, true);

    public static boolean isJavaVersion(int oracleJavaVersion, boolean noVersionOne) {
        String javaVersion = System.getProperty("java.version");
        if (noVersionOne) {
            return javaVersion.startsWith(String.valueOf(oracleJavaVersion));
        }
        return javaVersion.startsWith("1." + oracleJavaVersion);
    }

    public static boolean isJavaVersion(int oracleJavaVersion) {
        return JavaDetectionTools.isJavaVersion(oracleJavaVersion, false);
    }

    public static boolean isAtLeastOracleJavaUpdateVersion(int updateNumber) {
        String javaVersion = System.getProperty("java.version");
        String[] javaVersionSplitted = javaVersion.split("_");
        if (javaVersionSplitted.length <= 1) {
            return false;
        }
        String javaUpdateVersionRaw = javaVersionSplitted[1];
        String javaUpdateVersion = javaUpdateVersionRaw.replaceAll("[^\\d]", "");
        return Integer.parseInt(javaUpdateVersion, 10) >= updateNumber;
    }
}

