/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.io;

import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.io.FastByteArrayOutputStream;
import com.xiaoleilu.hutool.io.IORuntimeException;
import com.xiaoleilu.hutool.io.LineHandler;
import com.xiaoleilu.hutool.io.StreamProgress;
import com.xiaoleilu.hutool.lang.Assert;
import com.xiaoleilu.hutool.util.CharsetUtil;
import com.xiaoleilu.hutool.util.HexUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Collection;

public final class IoUtil {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final int DEFAULT_LARGE_BUFFER_SIZE = 4096;
    public static final int EOF = -1;

    private IoUtil() {
    }

    public static long copy(Reader reader, Writer writer) throws IOException {
        return IoUtil.copy(reader, writer, 1024);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize) throws IOException {
        return IoUtil.copy(reader, writer, bufferSize, null);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize, StreamProgress streamProgress) throws IOException {
        int readSize;
        char[] buffer = new char[bufferSize];
        long size = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        while ((readSize = reader.read(buffer, 0, bufferSize)) != -1) {
            writer.write(buffer, 0, readSize);
            size += (long)readSize;
            writer.flush();
            if (null == streamProgress) continue;
            streamProgress.progress(size);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return size;
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return IoUtil.copy(in, out, 1024);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        return IoUtil.copy(in, out, bufferSize, null);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IOException {
        if (null == in) {
            throw new NullPointerException("InputStream is null!");
        }
        if (null == out) {
            throw new NullPointerException("OutputStream is null!");
        }
        if (bufferSize <= 0) {
            bufferSize = 1024;
        }
        byte[] buffer = new byte[bufferSize];
        long size = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        int readSize = -1;
        while ((readSize = in.read(buffer)) != -1) {
            out.write(buffer, 0, readSize);
            size += (long)readSize;
            out.flush();
            if (null == streamProgress) continue;
            streamProgress.progress(size);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return size;
    }

    public static long copyByNIO(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IOException {
        return IoUtil.copy(Channels.newChannel(in), Channels.newChannel(out), bufferSize, streamProgress);
    }

    public static long copy(FileInputStream in, FileOutputStream out) throws IOException {
        if (null == in) {
            throw new NullPointerException("FileInputStream is null!");
        }
        if (null == out) {
            throw new NullPointerException("FileOutputStream is null!");
        }
        FileChannel inChannel = in.getChannel();
        FileChannel outChannel = out.getChannel();
        return inChannel.transferTo(0L, inChannel.size(), outChannel);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize, StreamProgress streamProgress) throws IOException {
        if (null == in) {
            throw new NullPointerException("In is null!");
        }
        if (null == out) {
            throw new NullPointerException("Out is null!");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize <= 0 ? 1024 : bufferSize);
        long size = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        while (in.read(byteBuffer) != -1) {
            byteBuffer.flip();
            size += (long)out.write(byteBuffer);
            byteBuffer.clear();
            if (null == streamProgress) continue;
            streamProgress.progress(size);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return size;
    }

    public static BufferedReader getReader(InputStream in, String charsetName) {
        return IoUtil.getReader(in, Charset.forName(charsetName));
    }

    public static BufferedReader getReader(InputStream in, Charset charset) {
        if (null == in) {
            return null;
        }
        InputStreamReader reader = null;
        reader = null == charset ? new InputStreamReader(in) : new InputStreamReader(in, charset);
        return new BufferedReader(reader);
    }

    public static BufferedReader getReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static PushbackReader getPushBackReader(Reader reader, int pushBackSize) {
        return reader instanceof PushbackReader ? (PushbackReader)reader : new PushbackReader(reader, pushBackSize);
    }

    public static OutputStreamWriter getWriter(OutputStream out, String charsetName) {
        return IoUtil.getWriter(out, Charset.forName(charsetName));
    }

    public static OutputStreamWriter getWriter(OutputStream out, Charset charset) {
        if (null == out) {
            return null;
        }
        if (null == charset) {
            return new OutputStreamWriter(out);
        }
        return new OutputStreamWriter(out, charset);
    }

    public static String read(InputStream in, String charsetName) throws IOException {
        FastByteArrayOutputStream out = IoUtil.read(in);
        return StrUtil.isBlank(charsetName) ? out.toString() : out.toString(charsetName);
    }

    public static String read(InputStream in, Charset charset) throws IOException {
        FastByteArrayOutputStream out = IoUtil.read(in);
        return null == charset ? out.toString() : out.toString(charset);
    }

    public static FastByteArrayOutputStream read(InputStream in) throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        IoUtil.copy(in, out);
        return out;
    }

    public static String read(Reader reader) throws IOException {
        StringBuilder builder = StrUtil.builder();
        CharBuffer buffer = CharBuffer.allocate(1024);
        while (-1 != reader.read(buffer)) {
            builder.append(buffer.flip().toString());
        }
        return builder.toString();
    }

    public static String read(FileChannel fileChannel, String charsetName) throws IOException {
        return IoUtil.read(fileChannel, CharsetUtil.charset(charsetName));
    }

    public static String read(FileChannel fileChannel, Charset charset) throws IOException {
        MappedByteBuffer buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size()).load();
        return StrUtil.str((ByteBuffer)buffer, charset);
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        IoUtil.copy(in, out);
        return out.toByteArray();
    }

    public static byte[] readBytes(InputStream in, int length) throws IOException {
        byte[] b = new byte[length];
        int readLength = in.read(b);
        if (readLength < length) {
            byte[] b2 = new byte[length];
            System.arraycopy(b, 0, b2, 0, readLength);
            return b2;
        }
        return b;
    }

    public static String readHex(InputStream in, int length, boolean toLowerCase) throws IOException {
        return HexUtil.encodeHexStr(IoUtil.readBytes(in, length), toLowerCase);
    }

    public static String readHex28Upper(InputStream in) throws IOException {
        return IoUtil.readHex(in, 28, false);
    }

    public static String readHex28Lower(InputStream in) throws IOException {
        return IoUtil.readHex(in, 28, true);
    }

    public static <T> T readObj(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(in);
            Object obj = ois.readObject();
            return (T)obj;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static <T extends Collection<String>> T readLines(InputStream in, String charsetName, T collection) throws IOException {
        return IoUtil.readLines(in, CharsetUtil.charset(charsetName), collection);
    }

    public static <T extends Collection<String>> T readLines(InputStream in, Charset charset, T collection) throws IOException {
        return IoUtil.readLines((Reader)IoUtil.getReader(in, charset), collection);
    }

    public static <T extends Collection<String>> T readLines(Reader reader, final T collection) throws IOException {
        IoUtil.readLines(reader, new LineHandler(){

            @Override
            public void handle(String line) {
                collection.add(line);
            }
        });
        return collection;
    }

    public static void readLines(InputStream in, Charset charset, LineHandler lineHandler) throws IOException {
        IoUtil.readLines((Reader)IoUtil.getReader(in, charset), lineHandler);
    }

    public static void readLines(Reader reader, LineHandler lineHandler) throws IOException {
        BufferedReader bReader = IoUtil.getReader(reader);
        String line = null;
        while ((line = bReader.readLine()) != null) {
            lineHandler.handle(line);
        }
    }

    public static ByteArrayInputStream toStream(String content, String charsetName) {
        return IoUtil.toStream(content, CharsetUtil.charset(charsetName));
    }

    public static ByteArrayInputStream toStream(String content, Charset charset) {
        if (content == null) {
            return null;
        }
        return new ByteArrayInputStream(StrUtil.bytes((CharSequence)content, charset));
    }

    public static FileInputStream toStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IORuntimeException(e);
        }
    }

    public static PushbackInputStream toPushbackStream(InputStream in, int pushBackSize) {
        return in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in, pushBackSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(OutputStream out, boolean isCloseOut, byte[] content) throws IOException {
        try {
            out.write(content);
        }
        finally {
            if (isCloseOut) {
                IoUtil.close(out);
            }
        }
    }

    public static void write(OutputStream out, String charsetName, boolean isCloseOut, Object ... contents) throws IOException {
        Assert.notNull(charsetName, "[charsetName] is null !", new Object[0]);
        IoUtil.write(out, Charset.forName(charsetName), isCloseOut, contents);
    }

    public static void write(OutputStream out, Charset charset, boolean isCloseOut, Object ... contents) throws IOException {
        OutputStreamWriter osw = null;
        try {
            osw = IoUtil.getWriter(out, charset);
            for (Object content : contents) {
                if (content == null) continue;
                osw.write(Convert.toStr(content, ""));
                osw.flush();
            }
        }
        catch (Exception e) {
            throw new IOException("Write content to OutputStream error!", e);
        }
        finally {
            if (isCloseOut) {
                IoUtil.close(osw);
            }
        }
    }

    public static void writeObjects(OutputStream out, String charsetName, boolean isCloseOut, Serializable ... contents) throws IOException {
        Assert.notNull(charsetName, "[charsetName] is null !", new Object[0]);
        IoUtil.writeObjects(out, Charset.forName(charsetName), isCloseOut, contents);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeObjects(OutputStream out, Charset charset, boolean isCloseOut, Serializable ... contents) throws IOException {
        ObjectOutputStream osw = null;
        try {
            osw = out instanceof ObjectOutputStream ? (ObjectOutputStream)out : new ObjectOutputStream(out);
            for (Serializable content : contents) {
                if (content == null) continue;
                osw.writeObject(content);
                osw.flush();
            }
            if (!isCloseOut) return;
        }
        catch (Exception e) {
            try {
                throw new IOException("Write content to OutputStream error!", e);
            }
            catch (Throwable throwable) {
                if (!isCloseOut) throw throwable;
                IoUtil.close(osw);
                throw throwable;
            }
        }
        IoUtil.close(osw);
        return;
    }

    public static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(AutoCloseable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

