/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.convert;

import com.xiaoleilu.hutool.convert.ConvertException;
import com.xiaoleilu.hutool.convert.Converter;
import com.xiaoleilu.hutool.convert.impl.ArrayConverter;
import com.xiaoleilu.hutool.convert.impl.AtomicBooleanConverter;
import com.xiaoleilu.hutool.convert.impl.AtomicReferenceConverter;
import com.xiaoleilu.hutool.convert.impl.BooleanConverter;
import com.xiaoleilu.hutool.convert.impl.CalendarConverter;
import com.xiaoleilu.hutool.convert.impl.CharacterConverter;
import com.xiaoleilu.hutool.convert.impl.CharsetConverter;
import com.xiaoleilu.hutool.convert.impl.ClassConverter;
import com.xiaoleilu.hutool.convert.impl.CurrencyConverter;
import com.xiaoleilu.hutool.convert.impl.DateConverter;
import com.xiaoleilu.hutool.convert.impl.NumberConverter;
import com.xiaoleilu.hutool.convert.impl.PathConverter;
import com.xiaoleilu.hutool.convert.impl.PrimitiveConverter;
import com.xiaoleilu.hutool.convert.impl.ReferenceConverter;
import com.xiaoleilu.hutool.convert.impl.StringConverter;
import com.xiaoleilu.hutool.convert.impl.TimeZoneConverter;
import com.xiaoleilu.hutool.convert.impl.URIConverter;
import com.xiaoleilu.hutool.convert.impl.URLConverter;
import com.xiaoleilu.hutool.date.DateTime;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.BeanUtil;
import com.xiaoleilu.hutool.util.ClassUtil;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Currency;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class ConverterRegistry {
    private Map<Type, Converter<?>> defaultConverterMap;
    private Map<Type, Converter<?>> customConverterMap;

    public static ConverterRegistry getInstance() {
        return SingletonHolder.instance;
    }

    public ConverterRegistry() {
        this.defaultConverter();
    }

    public ConverterRegistry putCustom(Type type, Class<? extends Converter<?>> converterClass) {
        return this.putCustom(type, ClassUtil.newInstance(converterClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConverterRegistry putCustom(Type type, Converter<?> converter) {
        if (null == this.customConverterMap) {
            ConverterRegistry converterRegistry = this;
            synchronized (converterRegistry) {
                if (null == this.customConverterMap) {
                    this.customConverterMap = new ConcurrentHashMap();
                }
            }
        }
        this.customConverterMap.put(type, converter);
        return this;
    }

    public <T> Converter<T> getConverter(Type type, boolean isCustomFirst) {
        Converter<T> converter = null;
        if (isCustomFirst) {
            converter = this.getCustomConverter(type);
            if (null == converter) {
                converter = this.getDefaultConverter(type);
            }
        } else {
            converter = this.getDefaultConverter(type);
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
        }
        return converter;
    }

    public <T> Converter<T> getDefaultConverter(Type type) {
        return null == this.defaultConverterMap ? null : this.defaultConverterMap.get(type);
    }

    public <T> Converter<T> getCustomConverter(Type type) {
        return null == this.customConverterMap ? null : this.customConverterMap.get(type);
    }

    public <T> T convert(Class<T> type, Object value, T defaultValue, boolean isCustomFirst) throws ConvertException {
        Converter<T> converter;
        if (null == type && null == defaultValue) {
            throw new NullPointerException("[type] and [defaultValue] are both null, we can not know what type to convert !");
        }
        if (null == value) {
            return defaultValue;
        }
        if (null == type) {
            type = defaultValue.getClass();
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        Class<?> valueClass = value.getClass();
        if (type.isArray() && valueClass.isArray()) {
            try {
                return (T)ArrayUtil.cast(type, value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (null != (converter = this.getConverter(type, isCustomFirst))) {
            return converter.convert(value, defaultValue);
        }
        if (BeanUtil.isBean(type) && value instanceof Map) {
            return (T)BeanUtil.mapToBean((Map)value, type, true);
        }
        throw new ConvertException("No Converter for type [{}]", type.getName());
    }

    public <T> T convert(Class<T> type, Object value, T defaultValue) throws ConvertException {
        return this.convert(type, value, defaultValue, true);
    }

    public <T> T convert(Class<T> type, Object value) throws ConvertException {
        return this.convert(type, value, null);
    }

    private ConverterRegistry defaultConverter() {
        this.defaultConverterMap = new ConcurrentHashMap();
        this.defaultConverterMap.put(Integer.TYPE, new PrimitiveConverter(Integer.TYPE));
        this.defaultConverterMap.put(Long.TYPE, new PrimitiveConverter(Long.TYPE));
        this.defaultConverterMap.put(Byte.TYPE, new PrimitiveConverter(Byte.TYPE));
        this.defaultConverterMap.put(Short.TYPE, new PrimitiveConverter(Short.TYPE));
        this.defaultConverterMap.put(Float.TYPE, new PrimitiveConverter(Float.TYPE));
        this.defaultConverterMap.put(Double.TYPE, new PrimitiveConverter(Double.TYPE));
        this.defaultConverterMap.put(Character.TYPE, new PrimitiveConverter(Character.TYPE));
        this.defaultConverterMap.put(Boolean.TYPE, new PrimitiveConverter(Boolean.TYPE));
        this.defaultConverterMap.put((Type)((Object)Number.class), new NumberConverter());
        this.defaultConverterMap.put((Type)((Object)Integer.class), new NumberConverter(Integer.class));
        this.defaultConverterMap.put((Type)((Object)AtomicInteger.class), new NumberConverter(AtomicInteger.class));
        this.defaultConverterMap.put((Type)((Object)Long.class), new NumberConverter(Long.class));
        this.defaultConverterMap.put((Type)((Object)AtomicLong.class), new NumberConverter(AtomicLong.class));
        this.defaultConverterMap.put((Type)((Object)Byte.class), new NumberConverter(Byte.class));
        this.defaultConverterMap.put((Type)((Object)Short.class), new NumberConverter(Short.class));
        this.defaultConverterMap.put((Type)((Object)Float.class), new NumberConverter(Float.class));
        this.defaultConverterMap.put((Type)((Object)Double.class), new NumberConverter(Double.class));
        this.defaultConverterMap.put((Type)((Object)Character.class), new CharacterConverter());
        this.defaultConverterMap.put((Type)((Object)Boolean.class), new BooleanConverter());
        this.defaultConverterMap.put((Type)((Object)AtomicBoolean.class), new AtomicBooleanConverter());
        this.defaultConverterMap.put((Type)((Object)BigDecimal.class), new NumberConverter(BigDecimal.class));
        this.defaultConverterMap.put((Type)((Object)BigInteger.class), new NumberConverter(BigInteger.class));
        this.defaultConverterMap.put((Type)((Object)String.class), new StringConverter());
        this.defaultConverterMap.put((Type)((Object)int[].class), new ArrayConverter(Integer.TYPE));
        this.defaultConverterMap.put((Type)((Object)long[].class), new ArrayConverter(Long.TYPE));
        this.defaultConverterMap.put((Type)((Object)byte[].class), new ArrayConverter(Byte.TYPE));
        this.defaultConverterMap.put((Type)((Object)short[].class), new ArrayConverter(Short.TYPE));
        this.defaultConverterMap.put((Type)((Object)float[].class), new ArrayConverter(Float.TYPE));
        this.defaultConverterMap.put((Type)((Object)double[].class), new ArrayConverter(Double.TYPE));
        this.defaultConverterMap.put((Type)((Object)boolean[].class), new ArrayConverter(Boolean.TYPE));
        this.defaultConverterMap.put((Type)((Object)char[].class), new ArrayConverter(Character.TYPE));
        this.defaultConverterMap.put((Type)((Object)Integer[].class), new ArrayConverter(Integer.class));
        this.defaultConverterMap.put((Type)((Object)Long[].class), new ArrayConverter(Long.class));
        this.defaultConverterMap.put((Type)((Object)Byte[].class), new ArrayConverter(Byte.class));
        this.defaultConverterMap.put((Type)((Object)Short[].class), new ArrayConverter(Short.class));
        this.defaultConverterMap.put((Type)((Object)Float[].class), new ArrayConverter(Float.class));
        this.defaultConverterMap.put((Type)((Object)Double[].class), new ArrayConverter(Double.class));
        this.defaultConverterMap.put((Type)((Object)Boolean[].class), new ArrayConverter(Boolean.class));
        this.defaultConverterMap.put((Type)((Object)Character[].class), new ArrayConverter(Character.class));
        this.defaultConverterMap.put((Type)((Object)String[].class), new ArrayConverter(String.class));
        this.defaultConverterMap.put((Type)((Object)URI.class), new URIConverter());
        this.defaultConverterMap.put((Type)((Object)URL.class), new URLConverter());
        this.defaultConverterMap.put((Type)((Object)Calendar.class), new CalendarConverter());
        this.defaultConverterMap.put((Type)((Object)java.util.Date.class), new DateConverter(java.util.Date.class));
        this.defaultConverterMap.put((Type)((Object)DateTime.class), new DateConverter(DateTime.class));
        this.defaultConverterMap.put((Type)((Object)Date.class), new DateConverter(Date.class));
        this.defaultConverterMap.put((Type)((Object)Time.class), new DateConverter(Time.class));
        this.defaultConverterMap.put((Type)((Object)Timestamp.class), new DateConverter(Timestamp.class));
        this.defaultConverterMap.put((Type)((Object)WeakReference.class), new ReferenceConverter(WeakReference.class));
        this.defaultConverterMap.put((Type)((Object)SoftReference.class), new ReferenceConverter(SoftReference.class));
        this.defaultConverterMap.put((Type)((Object)AtomicReference.class), new AtomicReferenceConverter());
        this.defaultConverterMap.put((Type)((Object)Class.class), new ClassConverter());
        this.defaultConverterMap.put((Type)((Object)TimeZone.class), new TimeZoneConverter());
        this.defaultConverterMap.put((Type)((Object)Charset.class), new CharsetConverter());
        this.defaultConverterMap.put((Type)((Object)Path.class), new PathConverter());
        this.defaultConverterMap.put((Type)((Object)Currency.class), new CurrencyConverter());
        return this;
    }

    private static class SingletonHolder {
        private static ConverterRegistry instance = new ConverterRegistry();

        private SingletonHolder() {
        }
    }
}

