/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.io.FastByteArrayOutputStream;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private ZipUtil() {
    }

    public static File zip(String srcPath) throws UtilException {
        return ZipUtil.zip(FileUtil.file(srcPath));
    }

    public static File zip(File srcFile) throws UtilException {
        File zipFile = FileUtil.file(srcFile.getParentFile(), FileUtil.mainName(srcFile) + ".zip");
        ZipUtil.zip(zipFile, false, srcFile);
        return zipFile;
    }

    public static File zip(String srcPath, String zipPath) throws UtilException {
        return ZipUtil.zip(srcPath, zipPath, false);
    }

    public static File zip(String srcPath, String zipPath, boolean withSrcDir) throws UtilException {
        File srcFile = FileUtil.file(srcPath);
        File zipFile = FileUtil.file(zipPath);
        ZipUtil.zip(zipFile, withSrcDir, srcFile);
        return zipFile;
    }

    public static File zip(File zipFile, boolean withSrcDir, File ... srcFiles) throws UtilException {
        ZipUtil.validateFiles(zipFile, srcFiles);
        ZipOutputStream out = null;
        try {
            out = ZipUtil.getZipOutputStream(zipFile);
            for (File srcFile : srcFiles) {
                String srcRootDir = srcFile.getCanonicalPath();
                if (srcFile.isFile() || withSrcDir) {
                    srcRootDir = srcFile.getParent();
                }
                ZipUtil.zip(out, srcRootDir, srcFile);
                out.flush();
            }
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
        finally {
            IoUtil.close(out);
        }
        return zipFile;
    }

    public static File zip(File zipFile, String path, String data, Charset charset) throws UtilException {
        return ZipUtil.zip(zipFile, path, (InputStream)IoUtil.toStream(data, charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zip(File zipFile, String path, InputStream in) throws UtilException {
        ZipOutputStream out = null;
        try {
            out = ZipUtil.getZipOutputStream(zipFile);
            ZipUtil.zip(out, path, in);
        }
        finally {
            IoUtil.close(out);
        }
        return zipFile;
    }

    public static File unzip(File zipFile) throws UtilException {
        return ZipUtil.unzip(zipFile, FileUtil.file(zipFile.getParentFile(), FileUtil.mainName(zipFile)));
    }

    public static File unzip(String zipFilePath) throws UtilException {
        return ZipUtil.unzip(FileUtil.file(zipFilePath));
    }

    public static File unzip(String zipFilePath, String outFileDir) throws UtilException {
        return ZipUtil.unzip(FileUtil.file(zipFilePath), FileUtil.mkdir(outFileDir));
    }

    public static File unzip(File zipFile, File outFile) throws UtilException {
        ZipFile zipFileObj = null;
        try {
            zipFileObj = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> em = zipFileObj.entries();
            ZipEntry zipEntry = null;
            File outItemFile = null;
            while (em.hasMoreElements()) {
                zipEntry = em.nextElement();
                outItemFile = new File(outFile, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    outItemFile.mkdirs();
                    continue;
                }
                FileUtil.touch(outItemFile);
                ZipUtil.copy(zipFileObj, zipEntry, outItemFile);
            }
        }
        catch (IOException e) {
            try {
                throw new UtilException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(zipFileObj);
                throw throwable;
            }
        }
        IoUtil.close(zipFileObj);
        return outFile;
    }

    public static byte[] gzip(String content, String charset) throws UtilException {
        return ZipUtil.gzip(StrUtil.bytes((CharSequence)content, charset));
    }

    public static byte[] gzip(byte[] val) throws UtilException {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(val.length);
        GZIPOutputStream gos = null;
        try {
            gos = new GZIPOutputStream(bos);
            gos.write(val, 0, val.length);
            gos.finish();
            gos.flush();
            val = bos.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new UtilException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(gos);
                throw throwable;
            }
        }
        IoUtil.close(gos);
        return val;
    }

    public static byte[] gzip(File file) throws UtilException {
        byte[] byArray;
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)file.length());
        GZIPOutputStream gos = null;
        try {
            gos = new GZIPOutputStream(bos);
            BufferedInputStream in = FileUtil.getInputStream(file);
            IoUtil.copy(in, gos);
            byArray = bos.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new UtilException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(gos);
                throw throwable;
            }
        }
        IoUtil.close(gos);
        return byArray;
    }

    public static String unGzip(byte[] buf, String charset) throws UtilException {
        return StrUtil.str(ZipUtil.unGzip(buf), charset);
    }

    public static byte[] unGzip(byte[] buf) throws UtilException {
        GZIPInputStream gzi = null;
        ByteArrayOutputStream bos = null;
        try {
            gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
            bos = new ByteArrayOutputStream(buf.length);
            IoUtil.copy(gzi, bos);
            buf = bos.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new UtilException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(gzi);
                throw throwable;
            }
        }
        IoUtil.close(gzi);
        return buf;
    }

    private static ZipOutputStream getZipOutputStream(File zipFile) {
        return new ZipOutputStream(new CheckedOutputStream(FileUtil.getOutputStream(zipFile), new CRC32()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(ZipOutputStream out, String srcRootDir, File file) throws UtilException {
        if (file == null) {
            return;
        }
        if (file.isFile()) {
            String subPath = FileUtil.subPath(srcRootDir, file);
            BufferedInputStream in = null;
            try {
                in = FileUtil.getInputStream(file);
                ZipUtil.zip(out, subPath, (InputStream)in);
            }
            finally {
                IoUtil.close(in);
            }
        } else {
            for (File childFile : file.listFiles()) {
                ZipUtil.zip(out, srcRootDir, childFile);
            }
        }
    }

    private static void zip(ZipOutputStream out, String path, InputStream in) throws UtilException {
        try {
            out.putNextEntry(new ZipEntry(path));
            IoUtil.copy(in, out);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
        finally {
            ZipUtil.closeEntry(out);
        }
    }

    private static void validateFiles(File zipFile, File ... srcFiles) throws UtilException {
        for (File srcFile : srcFiles) {
            if (!srcFile.exists()) {
                throw new UtilException(StrUtil.format((CharSequence)"File [{}] not exist!", srcFile.getAbsolutePath()));
            }
            try {
                if (srcFile.isDirectory() && zipFile.getParent().contains(srcFile.getCanonicalPath())) {
                    throw new UtilException("[zipPath] must not be the child directory of [srcPath]!");
                }
                if (zipFile.exists()) continue;
                FileUtil.touch(zipFile);
            }
            catch (IOException e) {
                throw new UtilException(e);
            }
        }
    }

    private static void closeEntry(ZipOutputStream out) {
        try {
            out.closeEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(ZipFile zipFile, ZipEntry zipEntry, File outItemFile) throws IOException {
        InputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = zipFile.getInputStream(zipEntry);
            out = FileUtil.getOutputStream(outItemFile);
            IoUtil.copy(in, out);
        }
        catch (Throwable throwable) {
            IoUtil.close(out);
            IoUtil.close(in);
            throw throwable;
        }
        IoUtil.close(out);
        IoUtil.close(in);
    }
}

