/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.lang.Assert;
import com.xiaoleilu.hutool.util.ClassUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class URLUtil {
    private URLUtil() {
    }

    public static URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new UtilException(e.getMessage(), e);
        }
    }

    public static URL getURL(String pathBaseClassLoader) {
        return ClassUtil.getClassLoader().getResource(pathBaseClassLoader);
    }

    public static URL getURL(String path, Class<?> clazz) {
        return clazz.getResource(path);
    }

    public static URL getURL(File file) {
        Assert.notNull(file, "File is null !", new Object[0]);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new UtilException("Error occured when get URL!", e);
        }
    }

    public static URL[] getURLs(File ... files) {
        URL[] urls = new URL[files.length];
        try {
            for (int i = 0; i < files.length; ++i) {
                urls[i] = files[i].toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new UtilException("Error occured when get URL!", e);
        }
        return urls;
    }

    public static String formatUrl(String url) {
        if (StrUtil.isBlank(url)) {
            return null;
        }
        if (url.startsWith("http://") || url.startsWith("https://")) {
            return url;
        }
        return "http://" + url;
    }

    public static String complateUrl(String baseUrl, String relativePath) {
        if (StrUtil.isBlank(baseUrl = URLUtil.formatUrl(baseUrl))) {
            return null;
        }
        try {
            URL absoluteUrl = new URL(baseUrl);
            URL parseUrl = new URL(absoluteUrl, relativePath);
            return parseUrl.toString();
        }
        catch (MalformedURLException e) {
            throw new UtilException(e);
        }
    }

    public static String encode(String url, String charset) {
        try {
            return URLEncoder.encode(url, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(e);
        }
    }

    public static String decode(String url, String charset) {
        try {
            return URLDecoder.decode(url, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(e);
        }
    }

    public static String getPath(String uriStr) {
        URI uri = null;
        try {
            uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            throw new UtilException(e);
        }
        return uri.getPath();
    }

    public static String getDecodedPath(URL url) {
        try {
            return URLUtil.toURI(url).getPath();
        }
        catch (UtilException e) {
            return url.getPath();
        }
    }

    public static URI toURI(URL url) {
        return URLUtil.toURI(url.toString());
    }

    public static URI toURI(String location) {
        try {
            return new URI(location.replace(" ", "%20"));
        }
        catch (URISyntaxException e) {
            throw new UtilException(e);
        }
    }
}

