/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.yar.yarclient;

import com.weibo.yar.yarclient.AbstractYarClient;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpYarClient
extends AbstractYarClient {
    private static Log log = LogFactory.getLog(HttpYarClient.class);
    private HttpClient httpClient = HttpClients.createDefault();
    private int soTimeout;
    private int connectTimeout;

    public HttpYarClient() {
        this(3000, 5000);
    }

    public HttpYarClient(int soTimeout, int connectTimeout) {
        this.soTimeout = soTimeout;
        this.connectTimeout = connectTimeout;
    }

    @Override
    protected byte[] httpPost(String url, Map<String, String> headers, byte[] content) {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.soTimeout).setConnectTimeout(this.connectTimeout).build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(content, ContentType.APPLICATION_FORM_URLENCODED));
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            int status = response.getStatusLine().getStatusCode();
            if (status >= 200 && status < 300) {
                HttpEntity entity = response.getEntity();
                return entity != null ? EntityUtils.toByteArray((HttpEntity)entity) : null;
            }
            log.error((Object)("Unexpected response status: " + status));
            return null;
        }
        catch (Exception e) {
            log.error((Object)"httpclient execute fail.", (Throwable)e);
            return null;
        }
    }
}

