/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.yar.packager;

import com.weibo.yar.packager.Packager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.msgpack.MessagePack;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.template.ListTemplate;
import org.msgpack.template.MapTemplate;
import org.msgpack.template.Template;
import org.msgpack.template.Templates;
import org.msgpack.type.ArrayValue;
import org.msgpack.type.IntegerValue;
import org.msgpack.type.MapValue;
import org.msgpack.type.Value;
import org.msgpack.unpacker.Converter;
import org.msgpack.unpacker.Unpacker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsgpackPackager
implements Packager {
    @Override
    public <E> byte[] encode(E value) throws IOException {
        MessagePack msgpack = new MessagePack();
        return msgpack.write(value);
    }

    @Override
    public <E> E decode(byte[] data, Class<E> messageType) throws IOException {
        MessagePack msgpack = new MessagePack();
        msgpack.register(Map.class, (Template)new MapTemplate(Templates.TString, (Template)new ObjectTemplate()));
        msgpack.register(List.class, (Template)new ListTemplate((Template)new ObjectTemplate()));
        Value dynamic = msgpack.read(data);
        Converter converter = new Converter(msgpack, dynamic);
        return (E)converter.read(messageType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectTemplate
    extends AbstractTemplate<Object> {
        public void write(Packer pk, Object v, boolean required) throws IOException {
            if (v == null) {
                if (required) {
                    throw new MessageTypeException("Attempted to write null");
                }
                pk.writeNil();
                return;
            }
            pk.write(v);
        }

        public Object read(Unpacker u, Object to, boolean required) throws IOException {
            if (!required && u.trySkipNil()) {
                return null;
            }
            return ObjectTemplate.toObject(u.readValue());
        }

        private static Object toObject(Value value) throws IOException {
            Converter conv = new Converter(value);
            if (value.isNilValue()) {
                return null;
            }
            if (value.isRawValue()) {
                return conv.read(Templates.TString);
            }
            if (value.isBooleanValue()) {
                return conv.read(Templates.TBoolean);
            }
            if (value.isIntegerValue()) {
                IntegerValue intValue = value.asIntegerValue();
                try {
                    int tempInt = intValue.getInt();
                    return conv.read(Templates.TInteger);
                }
                catch (Exception e) {
                    return conv.read(Templates.TLong);
                }
            }
            if (value.isFloatValue()) {
                return conv.read(Templates.TDouble);
            }
            if (value.isArrayValue()) {
                ArrayValue v = value.asArrayValue();
                ArrayList<Object> ret = new ArrayList<Object>(v.size());
                for (Value elementValue : v) {
                    ret.add(ObjectTemplate.toObject(elementValue));
                }
                return ret;
            }
            if (value.isMapValue()) {
                MapValue v = value.asMapValue();
                HashMap<Object, Object> map = new HashMap<Object, Object>(v.size());
                for (Map.Entry entry : v.entrySet()) {
                    Value key = (Value)entry.getKey();
                    Value val = (Value)entry.getValue();
                    map.put(ObjectTemplate.toObject(key), ObjectTemplate.toObject(val));
                }
                return map;
            }
            throw new RuntimeException("unknown msgpack type");
        }
    }
}

