/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.yar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class YarHeader {
    public static final long MAGIC_NUM = -2132808608L;
    public static final int HEADER_SIZE = 82;
    private long requestId = 0L;
    private int version = 0;
    private long reserved = 0L;
    private String provider = null;
    private String token = null;
    private long bodyLenght = 0L;

    public long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(long requestId) {
        this.requestId = requestId;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public long getReserved() {
        return this.reserved;
    }

    public void setReserved(long reserved) {
        this.reserved = reserved;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public long getBodyLenght() {
        return this.bodyLenght;
    }

    public void setBodyLenght(long bodyLenght) {
        this.bodyLenght = bodyLenght;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YarHeader fromBytes(byte[] bytes) throws IOException {
        YarHeader header = new YarHeader();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            header.setRequestId((long)in.readInt() & 0xFFFFFFFFL);
            header.setVersion(in.readUnsignedShort());
            if ((long)in.readInt() != -2132808608L) {
                throw new IOException("Invalid Yar header.");
            }
            header.setReserved((long)in.readInt() & 0xFFFFFFFFL);
            byte[] tempbyte = new byte[32];
            in.read(tempbyte, 0, 32);
            header.setProvider(new String(tempbyte));
            tempbyte = new byte[32];
            in.read(tempbyte, 0, 32);
            header.setToken(new String(tempbyte));
            header.setBodyLenght((long)in.readInt() & 0xFFFFFFFFL);
        }
        finally {
            in.close();
        }
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(82);
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            out.writeInt((int)this.getRequestId());
            out.writeShort((short)this.getVersion());
            out.writeInt(-2132808608);
            out.writeInt((int)this.reserved);
            out.write(new byte[64]);
            out.writeInt((int)this.getBodyLenght());
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        finally {
            byteStream.close();
            out.close();
        }
    }
}

