/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.tsv;

import com.univocity.parsers.common.AbstractWriter;
import com.univocity.parsers.tsv.TsvFormat;
import com.univocity.parsers.tsv.TsvWriterSettings;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;

public class TsvWriter
extends AbstractWriter<TsvWriterSettings> {
    private boolean ignoreLeading;
    private boolean ignoreTrailing;
    private boolean joinLines;
    private char escapeChar;
    private char newLine;

    public TsvWriter(TsvWriterSettings settings) {
        this((Writer)null, settings);
    }

    public TsvWriter(Writer writer, TsvWriterSettings settings) {
        super(writer, settings);
    }

    public TsvWriter(File file, TsvWriterSettings settings) {
        super(file, settings);
    }

    public TsvWriter(File file, String encoding, TsvWriterSettings settings) {
        super(file, encoding, settings);
    }

    public TsvWriter(File file, Charset encoding, TsvWriterSettings settings) {
        super(file, encoding, settings);
    }

    public TsvWriter(OutputStream output, TsvWriterSettings settings) {
        super(output, settings);
    }

    public TsvWriter(OutputStream output, String encoding, TsvWriterSettings settings) {
        super(output, encoding, settings);
    }

    public TsvWriter(OutputStream output, Charset encoding, TsvWriterSettings settings) {
        super(output, encoding, settings);
    }

    @Override
    protected final void initialize(TsvWriterSettings settings) {
        this.escapeChar = ((TsvFormat)settings.getFormat()).getEscapeChar();
        this.ignoreLeading = settings.getIgnoreLeadingWhitespaces();
        this.ignoreTrailing = settings.getIgnoreTrailingWhitespaces();
        this.joinLines = settings.isLineJoiningEnabled();
        this.newLine = ((TsvFormat)settings.getFormat()).getNormalizedNewline();
    }

    @Override
    protected void processRow(Object[] row) {
        for (int i = 0; i < row.length; ++i) {
            if (i != 0) {
                this.appendToRow('\t');
            }
            String nextElement = this.getStringValue(row[i]);
            int originalLength = this.appender.length();
            this.append(nextElement);
            if (this.appender.length() == originalLength && this.nullValue != null && !this.nullValue.isEmpty()) {
                this.append(this.nullValue);
            }
            this.appendValueToRow();
        }
    }

    private void append(String element) {
        if (element == null) {
            element = this.nullValue;
        }
        if (element == null) {
            return;
        }
        int start = 0;
        if (this.ignoreLeading) {
            start = TsvWriter.skipLeadingWhitespace(element);
        }
        if (this.ignoreTrailing) {
            for (int i = start; i < element.length(); ++i) {
                char ch = element.charAt(i);
                if (ch == '\t') {
                    this.appender.append(this.escapeChar);
                    this.appender.append('t');
                    continue;
                }
                if (ch == '\n') {
                    this.appender.append(this.escapeChar);
                    this.appender.append(this.joinLines ? (char)this.newLine : (char)'n');
                    continue;
                }
                if (ch == '\\') {
                    this.appender.append(this.escapeChar);
                    this.appender.append('\\');
                    continue;
                }
                if (ch == '\r') {
                    this.appender.append(this.escapeChar);
                    this.appender.append(this.joinLines ? (char)this.newLine : (char)'r');
                    continue;
                }
                this.appender.appendIgnoringWhitespace(ch);
            }
        } else {
            for (int i = start; i < element.length(); ++i) {
                char ch = element.charAt(i);
                if (ch == '\t') {
                    this.appender.append(this.escapeChar);
                    this.appender.append('t');
                    continue;
                }
                if (ch == '\n') {
                    this.appender.append(this.escapeChar);
                    this.appender.append(this.joinLines ? (char)this.newLine : (char)'n');
                    continue;
                }
                if (ch == '\\') {
                    this.appender.append(this.escapeChar);
                    this.appender.append('\\');
                    continue;
                }
                if (ch == '\r') {
                    this.appender.append(this.escapeChar);
                    this.appender.append(this.joinLines ? (char)this.newLine : (char)'r');
                    continue;
                }
                this.appender.append(ch);
            }
        }
    }
}

