/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.outbound;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.string.StringEncoder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.freeswitch.esl.client.outbound.IClientHandlerFactory;
import org.freeswitch.esl.client.outbound.OutboundClientHandler;
import org.freeswitch.esl.client.transport.message.EslFrameDecoder;

public class OutboundChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private final IClientHandlerFactory clientHandlerFactory;
    private ExecutorService callbackExecutor = Executors.newSingleThreadExecutor();

    public OutboundChannelInitializer(IClientHandlerFactory clientHandlerFactory) {
        this.clientHandlerFactory = clientHandlerFactory;
    }

    public OutboundChannelInitializer setCallbackExecutor(ExecutorService callbackExecutor) {
        this.callbackExecutor = callbackExecutor;
        return this;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("encoder", (ChannelHandler)new StringEncoder());
        pipeline.addLast("decoder", (ChannelHandler)new EslFrameDecoder(8092, true));
        pipeline.addLast("clientHandler", (ChannelHandler)new OutboundClientHandler(this.clientHandlerFactory.createClientHandler(), this.callbackExecutor));
    }
}

