/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import io.netty.channel.Channel;
import java.util.concurrent.CompletableFuture;
import org.freeswitch.esl.client.internal.AbstractEslClientHandler;
import org.freeswitch.esl.client.internal.IModEslApi;
import org.freeswitch.esl.client.transport.CommandResponse;
import org.freeswitch.esl.client.transport.SendMsg;
import org.freeswitch.esl.client.transport.event.EslEvent;
import org.freeswitch.esl.client.transport.message.EslMessage;

public class Context
implements IModEslApi {
    private final AbstractEslClientHandler handler;
    private final Channel channel;

    public Context(Channel channel, AbstractEslClientHandler clientHandler) {
        this.handler = clientHandler;
        this.channel = channel;
    }

    @Override
    public boolean canSend() {
        return this.channel != null && this.channel.isActive();
    }

    @Override
    public EslMessage sendApiCommand(String command, String arg) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)command) ? 1 : 0) != 0, (Object)"command cannot be null or empty");
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("api ").append(command);
            if (!Strings.isNullOrEmpty((String)arg)) {
                sb.append(' ').append(arg);
            }
            return (EslMessage)Futures.getUnchecked(this.handler.sendApiSingleLineCommand(this.channel, sb.toString()));
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EslEvent> sendBackgroundApiCommand(String command, String arg) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)command) ? 1 : 0) != 0, (Object)"command cannot be null or empty");
        StringBuilder sb = new StringBuilder();
        sb.append("bgapi ").append(command);
        if (!Strings.isNullOrEmpty((String)arg)) {
            sb.append(' ').append(arg);
        }
        return this.handler.sendBackgroundApiCommand(this.channel, sb.toString());
    }

    @Override
    public CommandResponse setEventSubscriptions(IModEslApi.EventFormat format, String events) {
        Preconditions.checkState((boolean)format.equals((Object)IModEslApi.EventFormat.PLAIN), (Object)"Only 'plain' event format is supported at present");
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("event ").append(format.toString());
            if (!Strings.isNullOrEmpty((String)events)) {
                sb.append(' ').append(events);
            }
            EslMessage response = (EslMessage)Futures.getUnchecked(this.handler.sendApiSingleLineCommand(this.channel, sb.toString()));
            return new CommandResponse(sb.toString(), response);
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    @Override
    public CommandResponse cancelEventSubscriptions() {
        try {
            EslMessage response = (EslMessage)Futures.getUnchecked(this.handler.sendApiSingleLineCommand(this.channel, "noevents"));
            return new CommandResponse("noevents", response);
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    @Override
    public CommandResponse addEventFilter(String eventHeader, String valueToFilter) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)eventHeader) ? 1 : 0) != 0, (Object)"eventHeader cannot be null or empty");
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("filter ").append(eventHeader);
            if (!Strings.isNullOrEmpty((String)valueToFilter)) {
                sb.append(' ').append(valueToFilter);
            }
            EslMessage response = (EslMessage)Futures.getUnchecked(this.handler.sendApiSingleLineCommand(this.channel, sb.toString()));
            return new CommandResponse(sb.toString(), response);
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    @Override
    public CommandResponse deleteEventFilter(String eventHeader, String valueToFilter) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)eventHeader) ? 1 : 0) != 0, (Object)"eventHeader cannot be null or empty");
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("filter delete ").append(eventHeader);
            if (!Strings.isNullOrEmpty((String)valueToFilter)) {
                sb.append(' ').append(valueToFilter);
            }
            EslMessage response = (EslMessage)Futures.getUnchecked(this.handler.sendApiSingleLineCommand(this.channel, sb.toString()));
            return new CommandResponse(sb.toString(), response);
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    @Override
    public CommandResponse sendMessage(SendMsg sendMsg) {
        Preconditions.checkNotNull((Object)sendMsg, (Object)"sendMsg cannot be null");
        try {
            EslMessage response = (EslMessage)Futures.getUnchecked(this.handler.sendApiMultiLineCommand(this.channel, sendMsg.getMsgLines()));
            return new CommandResponse(sendMsg.toString(), response);
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    @Override
    public CommandResponse setLoggingLevel(IModEslApi.LoggingLevel level) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("log ").append(level.toString());
            EslMessage response = (EslMessage)Futures.getUnchecked(this.handler.sendApiSingleLineCommand(this.channel, sb.toString()));
            return new CommandResponse(sb.toString(), response);
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    @Override
    public CommandResponse cancelLogging() {
        try {
            EslMessage response = (EslMessage)Futures.getUnchecked(this.handler.sendApiSingleLineCommand(this.channel, "nolog"));
            return new CommandResponse("nolog", response);
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    public void closeChannel() {
        try {
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close();
            }
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }
}

