/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.inbound;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import org.freeswitch.esl.client.inbound.Client;
import org.freeswitch.esl.client.inbound.IEslProtocolListener;
import org.freeswitch.esl.client.inbound.SocketCloseListener;
import org.freeswitch.esl.client.internal.AbstractEslClientHandler;
import org.freeswitch.esl.client.internal.Context;
import org.freeswitch.esl.client.transport.CommandResponse;
import org.freeswitch.esl.client.transport.event.EslEvent;
import org.freeswitch.esl.client.transport.message.EslMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
class InboundClientHandler
extends AbstractEslClientHandler {
    private final Logger log = LoggerFactory.getLogger(InboundClientHandler.class);
    private final String password;
    private final IEslProtocolListener listener;
    private final Client client;
    private SocketCloseListener closeListener;

    public InboundClientHandler(String password, IEslProtocolListener listener, Client client) {
        this.password = password;
        this.listener = listener;
        this.client = client;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.log.warn("socket is closed:{}", (Object)ctx.channel());
        if (this.closeListener != null) {
            this.closeListener.closed();
        }
    }

    @Override
    protected void handleEslEvent(ChannelHandlerContext ctx, EslEvent event) {
        this.log.debug("Received event: [{}]", (Object)event);
        this.listener.eventReceived(new Context(ctx.channel(), this), event);
    }

    @Override
    protected void handleAuthRequest(ChannelHandlerContext ctx) {
        this.log.debug("Auth requested, sending [auth {}]", (Object)"*****");
        this.sendApiSingleLineCommand(ctx.channel(), "auth " + this.password).thenAccept(response -> {
            this.log.debug("Auth response [{}]", response);
            if (!response.getContentType().equals("command/reply")) {
                this.log.error("Bad auth response message [{}]", response);
                throw new IllegalStateException("Incorrect auth response");
            }
            CommandResponse commandResponse = new CommandResponse("auth " + this.password, (EslMessage)response);
            this.listener.authResponseReceived(commandResponse);
        });
    }

    @Override
    protected void handleDisconnectionNotice() {
        this.log.debug("Received disconnection notice");
        this.listener.disconnected();
    }

    public void setCloseListener(SocketCloseListener closeListener) {
        this.closeListener = closeListener;
    }
}

