/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.inbound;

import com.google.common.base.Throwables;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.SocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.freeswitch.esl.client.inbound.HeartbeatChecker;
import org.freeswitch.esl.client.inbound.IEslEventListener;
import org.freeswitch.esl.client.inbound.IEslProtocolListener;
import org.freeswitch.esl.client.inbound.InboundChannelInitializer;
import org.freeswitch.esl.client.inbound.InboundClientHandler;
import org.freeswitch.esl.client.inbound.InboundConnectionFailure;
import org.freeswitch.esl.client.inbound.ReconnectTask;
import org.freeswitch.esl.client.inbound.SocketCloseListener;
import org.freeswitch.esl.client.internal.Context;
import org.freeswitch.esl.client.internal.IModEslApi;
import org.freeswitch.esl.client.transport.CommandResponse;
import org.freeswitch.esl.client.transport.SendMsg;
import org.freeswitch.esl.client.transport.event.EslEvent;
import org.freeswitch.esl.client.transport.message.EslMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client
implements IModEslApi,
SocketCloseListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<IEslEventListener> eventListeners = new CopyOnWriteArrayList<IEslEventListener>();
    private final AtomicBoolean authenticatorResponded = new AtomicBoolean(false);
    private final ConcurrentHashMap<String, CompletableFuture<EslEvent>> backgroundJobs = new ConcurrentHashMap();
    private boolean authenticated;
    private CommandResponse authenticationResponse;
    private Optional<Context> clientContext = Optional.empty();
    private ExecutorService callbackExecutor = Executors.newSingleThreadExecutor();
    private SocketAddress clientAddress;
    private String password;
    private int timeoutSeconds;
    private String events;
    private EventLoopGroup workerGroup;
    private Bootstrap bootstrap;
    private HeartbeatChecker heartbeatChecker;
    private volatile Boolean reconnecting = false;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final IEslProtocolListener protocolListener = new IEslProtocolListener(){

        @Override
        public void authResponseReceived(CommandResponse response) {
            Client.this.authenticatorResponded.set(true);
            Client.this.authenticated = response.isOk();
            Client.this.authenticationResponse = response;
            Client.this.log.debug("Auth response success={}, message=[{}]", (Object)Client.this.authenticated, (Object)response.getReplyText());
        }

        @Override
        public void eventReceived(Context ctx, EslEvent event) {
            String evtName = event.getEventName();
            if ("HEARTBEAT".equals(evtName)) {
                if (Client.this.log.isDebugEnabled()) {
                    Client.this.log.debug("received a heartbeat event");
                }
                if (Client.this.heartbeatChecker != null) {
                    Client.this.heartbeatChecker.setLtsActive(System.currentTimeMillis());
                }
                return;
            }
            Client.this.log.debug("Event received [{}]", (Object)event);
            for (IEslEventListener listener : Client.this.eventListeners) {
                Client.this.callbackExecutor.execute(() -> listener.onEslEvent(ctx, event));
            }
        }

        @Override
        public void disconnected() {
            Client.this.log.info("Disconnected ...");
        }
    };

    public void addEventListener(IEslEventListener listener) {
        if (listener != null) {
            this.eventListeners.add(listener);
        }
    }

    @Override
    public boolean canSend() {
        return this.clientContext.isPresent() && this.clientContext.get().canSend() && this.authenticated;
    }

    private void checkConnected() {
        if (!this.canSend()) {
            throw new IllegalStateException("Not connected to FreeSWITCH Event Socket");
        }
    }

    public void setCallbackExecutor(ExecutorService callbackExecutor) {
        this.callbackExecutor = callbackExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(SocketAddress clientAddress, String password, int timeoutSeconds) throws Exception {
        if (this.heartbeatChecker != null) {
            this.heartbeatChecker.setStop(true);
        }
        this.setClientAddress(clientAddress);
        this.setPassword(password);
        this.setTimeoutSeconds(timeoutSeconds);
        if (this.canSend()) {
            this.close();
        }
        this.log.info("Connecting to {} ...", (Object)clientAddress);
        this.workerGroup = new NioEventLoopGroup();
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        InboundClientHandler handler = new InboundClientHandler(password, this.protocolListener, this);
        handler.setCloseListener(this);
        this.bootstrap.handler((ChannelHandler)new InboundChannelInitializer((ChannelHandler)handler));
        ChannelFuture future = this.bootstrap.connect(clientAddress);
        if (!future.sync().awaitUninterruptibly((long)timeoutSeconds, TimeUnit.SECONDS)) {
            throw new InboundConnectionFailure("Timeout connecting to " + clientAddress);
        }
        Channel channel = future.channel();
        if (!future.isSuccess()) {
            this.log.warn("Failed to connect to [{}]", (Object)clientAddress, (Object)future.cause());
            throw new InboundConnectionFailure("Could not connect to " + clientAddress, future.cause());
        }
        this.log.info("Connected to {}", (Object)clientAddress);
        while (!this.authenticatorResponded.get()) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.clientContext = Optional.of(new Context(channel, handler));
        if (!this.authenticated) {
            throw new InboundConnectionFailure("Authentication failed: " + this.authenticationResponse.getReplyText());
        }
        this.log.info("Authenticated");
        this.heartbeatChecker = new HeartbeatChecker(this);
        this.scheduler.scheduleWithFixedDelay(this.heartbeatChecker, 0L, 2L, TimeUnit.SECONDS);
        Boolean bl = this.reconnecting;
        synchronized (bl) {
            this.reconnecting = false;
        }
    }

    @Override
    public EslMessage sendApiCommand(String command, String arg) {
        this.checkConnected();
        return this.clientContext.get().sendApiCommand(command, arg);
    }

    @Override
    public CompletableFuture<EslEvent> sendBackgroundApiCommand(String command, String arg) {
        this.checkConnected();
        return this.clientContext.get().sendBackgroundApiCommand(command, arg);
    }

    @Override
    public CommandResponse setEventSubscriptions(IModEslApi.EventFormat format, String events) {
        this.checkConnected();
        this.setEvents(events);
        return this.clientContext.get().setEventSubscriptions(format, events);
    }

    @Override
    public CommandResponse cancelEventSubscriptions() {
        this.checkConnected();
        return this.clientContext.get().cancelEventSubscriptions();
    }

    @Override
    public CommandResponse addEventFilter(String eventHeader, String valueToFilter) {
        this.checkConnected();
        return this.clientContext.get().addEventFilter(eventHeader, valueToFilter);
    }

    @Override
    public CommandResponse deleteEventFilter(String eventHeader, String valueToFilter) {
        this.checkConnected();
        return this.clientContext.get().deleteEventFilter(eventHeader, valueToFilter);
    }

    @Override
    public CommandResponse sendMessage(SendMsg sendMsg) {
        this.checkConnected();
        return this.clientContext.get().sendMessage(sendMsg);
    }

    @Override
    public CommandResponse setLoggingLevel(IModEslApi.LoggingLevel level) {
        this.checkConnected();
        return this.clientContext.get().setLoggingLevel(level);
    }

    @Override
    public CommandResponse cancelLogging() {
        this.checkConnected();
        return this.clientContext.get().cancelLogging();
    }

    public CommandResponse close() {
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            this.bootstrap = null;
            return null;
        }
        try {
            if (this.clientContext.isPresent()) {
                return new CommandResponse("exit", this.clientContext.get().sendApiCommand("exit", null));
            }
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
        return null;
    }

    public SocketAddress getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(SocketAddress clientAddress) {
        this.clientAddress = clientAddress;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public String getEvents() {
        return this.events;
    }

    public void setEvents(String events) {
        this.events = events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closed() {
        Boolean bl = this.reconnecting;
        synchronized (bl) {
            if (this.reconnecting.booleanValue()) {
                this.log.warn("reconnecting task is already start");
                return;
            }
            this.reconnecting = true;
            ReconnectTask task = new ReconnectTask(this);
            this.scheduler.scheduleWithFixedDelay(task, 0L, 5L, TimeUnit.SECONDS);
        }
    }
}

