/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.outbound;

import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.freeswitch.esl.client.internal.AbstractEslClientHandler;
import org.freeswitch.esl.client.internal.Context;
import org.freeswitch.esl.client.outbound.IClientHandler;
import org.freeswitch.esl.client.transport.event.EslEvent;
import org.freeswitch.esl.client.transport.message.EslMessage;

class OutboundClientHandler
extends AbstractEslClientHandler {
    private final IClientHandler clientHandler;
    private final ExecutorService callbackExecutor;

    public OutboundClientHandler(IClientHandler clientHandler, ExecutorService callbackExecutor) {
        this.clientHandler = clientHandler;
        this.callbackExecutor = callbackExecutor;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.log.debug("Received new connection from server, sending connect message");
        ((CompletableFuture)this.sendApiSingleLineCommand(ctx.channel(), "connect").thenAccept(response -> this.clientHandler.onConnect(new Context(ctx.channel(), this), new EslEvent((EslMessage)response, true)))).exceptionally(throwable -> {
            ctx.channel().close();
            this.handleDisconnectionNotice();
            return null;
        });
    }

    @Override
    protected void handleEslEvent(ChannelHandlerContext ctx, EslEvent event) {
        this.callbackExecutor.execute(() -> this.clientHandler.onEslEvent(new Context(ctx.channel(), this), event));
    }

    @Override
    protected void handleAuthRequest(ChannelHandlerContext ctx) {
        this.log.warn("Auth request received in outbound mode, ignoring");
    }

    @Override
    protected void handleDisconnectionNotice() {
        this.log.debug("Received disconnection notice");
    }
}

